/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSLenType;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.IOException;
import java.util.Calendar;

final class ServerDTVImpl
extends DTVImpl {
    private int valueLength;
    private TDSReaderMark valueMark;
    private boolean isNull;
    private static final int STREAMCONSUMED = -2;

    ServerDTVImpl() {
    }

    @Override
    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(sQLCollation, jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection);
    }

    @Override
    void setValue(Object object, JavaType javaType) {
        assert (false);
    }

    void setPositionAfterStreamed(TDSReader tDSReader) {
        this.valueMark = tDSReader.mark();
        this.valueLength = -2;
    }

    @Override
    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        assert (false);
    }

    @Override
    void setCalendar(Calendar calendar) {
        assert (false);
    }

    @Override
    void setScale(Integer n) {
        assert (false);
    }

    @Override
    StreamSetterArgs getStreamSetterArgs() {
        assert (false);
        return null;
    }

    @Override
    Calendar getCalendar() {
        assert (false);
        return null;
    }

    @Override
    Integer getScale() {
        assert (false);
        return null;
    }

    @Override
    boolean isNull() {
        return this.isNull;
    }

    @Override
    void setJdbcType(JDBCType jDBCType) {
        assert (false);
    }

    @Override
    JDBCType getJdbcType() {
        assert (false);
        return JDBCType.UNKNOWN;
    }

    @Override
    JavaType getJavaType() {
        assert (false);
        return JavaType.OBJECT;
    }

    @Override
    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        tDSReader.reset(this.valueMark);
        if (this.valueLength != -2) {
            if (this.valueLength == -1) {
                assert (SSLenType.PARTLENTYPE == typeInfo.getSSLenType());
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, bl, this);
                try {
                    if (null != pLPInputStream) {
                        pLPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    tDSReader.getConnection().terminate(3, iOException.getMessage());
                }
            } else {
                assert (this.valueLength >= 0);
                tDSReader.skip(this.valueLength);
            }
        }
    }

    private final void getValuePrep(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        assert (null == this.valueMark);
        switch (typeInfo.getSSLenType()) {
            case PARTLENTYPE: {
                this.valueLength = -1;
                this.isNull = PLPInputStream.isNull(tDSReader);
                break;
            }
            case FIXEDLENTYPE: {
                this.valueLength = typeInfo.getMaxLength();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case BYTELENTYPE: {
                this.valueLength = tDSReader.readUnsignedByte();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case USHORTLENTYPE: {
                this.valueLength = tDSReader.readUnsignedShort();
                boolean bl = this.isNull = 65535 == this.valueLength;
                if (!this.isNull) break;
                this.valueLength = 0;
                break;
            }
            case LONGLENTYPE: {
                if (SSType.TEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType()) {
                    boolean bl = this.isNull = 0 == tDSReader.readUnsignedByte();
                    if (this.isNull) {
                        this.valueLength = 0;
                        break;
                    }
                    tDSReader.skip(24);
                    this.valueLength = tDSReader.readInt();
                    break;
                }
                this.valueLength = tDSReader.readInt();
                boolean bl = this.isNull = 0 == this.valueLength;
            }
        }
        if (this.valueLength > typeInfo.getMaxLength()) {
            tDSReader.throwInvalidTDS();
        }
        this.valueMark = tDSReader.mark();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    Object getValue(DTV var1_1, JDBCType var2_2, int var3_3, InputStreamGetterArgs var4_4, Calendar var5_5, TypeInfo var6_6, TDSReader var7_7) throws SQLServerException {
        block33: {
            var8_8 = null;
            if (null == this.valueMark) {
                this.getValuePrep(var6_6, var7_7);
            }
            var9_9 = false;
            if (null != var4_4) {
                if (!var4_4.streamType.convertsFrom(var6_6)) {
                    DataTypes.throwConversionError(var6_6.getSSType().toString(), var4_4.streamType.toString());
                }
            } else {
                if (!var6_6.getSSType().convertsTo(var2_2)) {
                    DataTypes.throwConversionError(var6_6.getSSType().toString(), var2_2.toString());
                }
                var4_4 = InputStreamGetterArgs.getDefaultArgs();
            }
            if (-2 == this.valueLength) {
                throw new SQLServerException(null, SQLServerException.getErrString("R_dataAlreadyAccessed"), null, 0, false);
            }
            if (this.isNull) break block33;
            var7_7.reset(this.valueMark);
            block0 : switch (1.$SwitchMap$com$microsoft$sqlserver$jdbc$SSType[var6_6.getSSType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    var8_8 = DDC.convertStreamToObject(PLPInputStream.makeStream(var7_7, var4_4, this), var6_6, var2_2, var4_4);
                    break;
                }
                case 5: {
                    if (var2_2.isBinary()) ** GOTO lbl-1000
                    if (var2_2 == JDBCType.SQLXML) lbl-1000:
                    // 2 sources

                    {
                        v0 /* !! */  = PLPXMLInputStream.makeXMLStream(var7_7, var4_4, this);
                    } else {
                        v0 /* !! */  = PLPInputStream.makeStream(var7_7, var4_4, this);
                    }
                    var8_8 = DDC.convertStreamToObject(v0 /* !! */ , var6_6, var2_2, var4_4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    var8_8 = DDC.convertStreamToObject(new SimpleInputStream(var7_7, this.valueLength, var4_4, this), var6_6, var2_2, var4_4);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    switch (this.valueLength) {
                        case 8: {
                            var8_8 = DDC.convertLongToObject(var7_7.readLong(), var2_2, var4_4.streamType);
                            break block0;
                        }
                        case 4: {
                            var8_8 = DDC.convertIntegerToObject(var7_7.readInt(), this.valueLength, var2_2, var4_4.streamType);
                            break block0;
                        }
                        case 2: {
                            var8_8 = DDC.convertIntegerToObject(var7_7.readShort(), this.valueLength, var2_2, var4_4.streamType);
                            break block0;
                        }
                        case 1: {
                            var8_8 = DDC.convertIntegerToObject(var7_7.readUnsignedByte(), this.valueLength, var2_2, var4_4.streamType);
                            break block0;
                        }
                    }
                    if (!ServerDTVImpl.$assertionsDisabled) {
                        throw new AssertionError((Object)("Unexpected valueLength" + this.valueLength));
                    }
                    break;
                }
                case 21: 
                case 22: {
                    var8_8 = var7_7.readDecimal(this.valueLength, var6_6, var2_2, var4_4.streamType);
                    break;
                }
                case 23: 
                case 24: {
                    var8_8 = var7_7.readMoney(this.valueLength, var2_2, var4_4.streamType);
                    break;
                }
                case 25: {
                    var8_8 = var7_7.readFloat(this.valueLength, var2_2, var4_4.streamType);
                    break;
                }
                case 26: {
                    var8_8 = var7_7.readReal(this.valueLength, var2_2, var4_4.streamType);
                    break;
                }
                case 27: 
                case 28: {
                    var8_8 = var7_7.readDateTime(this.valueLength, var5_5, var2_2, var4_4.streamType);
                    break;
                }
                case 29: {
                    var8_8 = var7_7.readDate(this.valueLength, var5_5, var2_2);
                    break;
                }
                case 30: {
                    var8_8 = var7_7.readTime(this.valueLength, var6_6, var5_5, var2_2);
                    break;
                }
                case 31: {
                    var8_8 = var7_7.readDateTime2(this.valueLength, var6_6, var5_5, var2_2);
                    break;
                }
                case 32: {
                    var8_8 = var7_7.readDateTimeOffset(this.valueLength, var6_6, var2_2);
                    break;
                }
                case 33: {
                    var8_8 = var7_7.readGUID(this.valueLength, var2_2, var4_4.streamType);
                    break;
                }
                default: {
                    if (!ServerDTVImpl.$assertionsDisabled) {
                        throw new AssertionError((Object)("Unexpected SSType " + (Object)var6_6.getSSType()));
                    }
                    break;
                }
            }
        }
        if (!ServerDTVImpl.$assertionsDisabled && !this.isNull && null == var8_8) {
            throw new AssertionError();
        }
        return var8_8;
    }

    @Override
    Object getSetterValue() {
        assert (false);
        return null;
    }
}

