/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.partition;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionSchema
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
ResourceHolderInterface {
    public static final String XML_TAG = "partitionschema";
    private String name;
    private List<String> partitionIDs;
    private boolean shared;
    private long id;
    private boolean dynamicallyDefined;
    private String numberOfPartitionsPerSlave;

    public PartitionSchema() {
        this.partitionIDs = new ArrayList<String>();
    }

    public PartitionSchema(String name, List<String> partitionIDs) {
        this.name = name;
        this.partitionIDs = partitionIDs;
    }

    public Object clone() {
        PartitionSchema partitionSchema = new PartitionSchema();
        partitionSchema.replaceMeta(this);
        partitionSchema.setId(-1L);
        return partitionSchema;
    }

    public void replaceMeta(PartitionSchema partitionSchema) {
        this.name = partitionSchema.name;
        this.partitionIDs = new ArrayList<String>();
        this.partitionIDs.addAll(partitionSchema.partitionIDs);
        this.dynamicallyDefined = partitionSchema.dynamicallyDefined;
        this.numberOfPartitionsPerSlave = partitionSchema.numberOfPartitionsPerSlave;
        this.setId(partitionSchema.id);
        this.setChanged(true);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.name == null) {
            return false;
        }
        return this.name.equals(((PartitionSchema)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPartitionIDs() {
        return this.partitionIDs;
    }

    public void setPartitionIDs(List<String> partitionIDs) {
        this.partitionIDs = partitionIDs;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(200);
        xml.append("        <").append(XML_TAG).append(">").append(Const.CR);
        xml.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        for (int i = 0; i < this.partitionIDs.size(); ++i) {
            xml.append("          <partition>");
            xml.append("            ").append(XMLHandler.addTagValue((String)"id", (String)this.partitionIDs.get(i)));
            xml.append("          </partition>");
        }
        xml.append("          ").append(XMLHandler.addTagValue((String)"dynamic", (boolean)this.dynamicallyDefined));
        xml.append("          ").append(XMLHandler.addTagValue((String)"partitions_per_slave", (String)this.numberOfPartitionsPerSlave));
        xml.append("        </").append(XML_TAG).append(">").append(Const.CR);
        return xml.toString();
    }

    public PartitionSchema(Node partitionSchemaNode) {
        this.name = XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"name");
        int nrIDs = XMLHandler.countNodes((Node)partitionSchemaNode, (String)"partition");
        this.partitionIDs = new ArrayList<String>();
        for (int i = 0; i < nrIDs; ++i) {
            Node partitionNode = XMLHandler.getSubNodeByNr((Node)partitionSchemaNode, (String)"partition", (int)i);
            this.partitionIDs.add(XMLHandler.getTagValue((Node)partitionNode, (String)"id"));
        }
        this.dynamicallyDefined = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"dynamic"));
        this.numberOfPartitionsPerSlave = XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"partitions_per_slave");
    }

    public void saveRep(Repository rep) throws KettleException {
        this.saveRep(rep, -1L, false);
    }

    public void saveRep(Repository rep, long id_transformation, boolean isUsedByTransformation) throws KettleException {
        this.setId(rep.getPartitionSchemaID(this.name));
        if (this.getId() < 0L) {
            this.setId(rep.insertPartitionSchema(this));
        } else {
            rep.updatePartitionSchema(this);
            rep.delPartitions(this.getId());
        }
        for (int i = 0; i < this.partitionIDs.size(); ++i) {
            rep.insertPartition(this.getId(), this.partitionIDs.get(i));
        }
        if (isUsedByTransformation) {
            rep.insertTransformationPartitionSchema(id_transformation, this.getId());
        }
    }

    public PartitionSchema(Repository rep, long id_partition_schema) throws KettleException {
        this();
        this.setId(id_partition_schema);
        RowMetaAndData row = rep.getPartitionSchema(id_partition_schema);
        this.name = row.getString("NAME", null);
        long[] pids = rep.getPartitionIDs(id_partition_schema);
        this.partitionIDs = new ArrayList<String>();
        for (int i = 0; i < pids.length; ++i) {
            this.partitionIDs.add(rep.getPartition(pids[i]).getString("PARTITION_ID", null));
        }
        this.dynamicallyDefined = row.getBoolean("DYNAMIC_DEFINITION", false);
        this.numberOfPartitionsPerSlave = row.getString("PARTITIONS_PER_SLAVE", null);
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getHolderType() {
        return "PARTITION_SCHEMA";
    }

    @Override
    public String getTypeId() {
        return null;
    }

    public boolean isDynamicallyDefined() {
        return this.dynamicallyDefined;
    }

    public void setDynamicallyDefined(boolean dynamicallyDefined) {
        this.dynamicallyDefined = dynamicallyDefined;
    }

    public String getNumberOfPartitionsPerSlave() {
        return this.numberOfPartitionsPerSlave;
    }

    public void setNumberOfPartitionsPerSlave(String numberOfPartitionsPerSlave) {
        this.numberOfPartitionsPerSlave = numberOfPartitionsPerSlave;
    }

    public void expandPartitionsDynamically(int nrSlaves, VariableSpace space) {
        this.partitionIDs.clear();
        int nrPartitionsPerSlave = Const.toInt((String)space.environmentSubstitute(this.numberOfPartitionsPerSlave), (int)1);
        int totalNumberOfPartitions = nrSlaves * nrPartitionsPerSlave;
        for (int partitionNumber = 0; partitionNumber < totalNumberOfPartitions; ++partitionNumber) {
            this.partitionIDs.add("PDyn" + partitionNumber);
        }
        this.dynamicallyDefined = false;
        this.numberOfPartitionsPerSlave = null;
    }

    public void retainPartitionsForSlaveServer(int slaveCount, int slaveNumber) {
        ArrayList<String> ids = new ArrayList<String>();
        int partitionCount = this.partitionIDs.size();
        for (int i = 0; i < partitionCount; ++i) {
            if (slaveNumber != i % slaveCount) continue;
            ids.add(this.partitionIDs.get(i));
        }
        this.partitionIDs.clear();
        this.partitionIDs.addAll(ids);
    }
}

