/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.enterprise.ArchitectPersisterSuperConverter;
import ca.sqlpower.architect.enterprise.ArchitectSessionPersister;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.enterprise.CompareRevisionsPanel;
import ca.sqlpower.architect.swingui.enterprise.RevisionsTable;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.json.SPJSONMessageDecoder;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class RevisionListPanel {
    public static final int DEFAULT_REVISION_RANGE = 100;
    private static final Logger logger = Logger.getLogger(RevisionListPanel.class);
    private final Component dialogOwner;
    private final ArchitectClientSideSession session;
    private final ArchitectSwingSession swingSession;
    private final RevisionsTable revisionsTable;
    private final JPanel panel;
    private JLongField fromVersion;
    private JLongField toVersion;
    private int currentVersion;
    private final JCheckBox autoRefreshBox;
    private final Runnable autoRefresh;
    private final Action refreshAction = new AbstractAction("Refresh..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean filterChange = RevisionListPanel.this.fromVersion.update() || RevisionListPanel.this.toVersion.update();
            int difference = RevisionListPanel.this.session.getUpdater().getRevision() - RevisionListPanel.this.currentVersion;
            if (difference > 0) {
                RevisionListPanel.this.currentVersion += difference;
            }
            if (RevisionListPanel.this.toVersion.getValue() > (long)RevisionListPanel.this.currentVersion) {
                RevisionListPanel.this.toVersion.setValue(RevisionListPanel.this.currentVersion);
            } else if (RevisionListPanel.this.fromVersion.getValue() > RevisionListPanel.this.toVersion.getValue()) {
                long to = RevisionListPanel.this.toVersion.getValue() - 100L;
                if (to <= 0L) {
                    to = 1L;
                }
                RevisionListPanel.this.fromVersion.setValue(to);
            }
            if (difference > 0 && RevisionListPanel.this.toVersion.getValue() == (long)(RevisionListPanel.this.currentVersion - difference)) {
                RevisionListPanel.this.fromVersion.setValue(RevisionListPanel.this.fromVersion.getValue() + (long)difference);
                RevisionListPanel.this.toVersion.setValue(RevisionListPanel.this.currentVersion);
            }
            if (difference > 0 || filterChange) {
                RevisionListPanel.this.revisionsTable.refreshRevisionsList(RevisionListPanel.this.fromVersion.getValue(), RevisionListPanel.this.toVersion.getValue());
                RevisionListPanel.this.refreshPanel();
            }
        }
    };
    private final Action revertAction = new AbstractAction("Revert..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final int revisionNo = RevisionListPanel.this.revisionsTable.getSelectedRevisionNumber();
            if (revisionNo >= RevisionListPanel.this.currentVersion) {
                JOptionPane.showMessageDialog(RevisionListPanel.this.dialogOwner, "Cannot revert to the current version number");
                return;
            }
            int response = JOptionPane.showConfirmDialog(RevisionListPanel.this.dialogOwner, "Are you sure you would like to revert to version " + revisionNo, "Revert...", 2);
            if (response == 0) {
                RevisionListPanel.this.revertAction.setEnabled(false);
                RevisionListPanel.this.swingSession.runInBackground(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final int currentVersion = RevisionListPanel.this.session.revertServerWorkspace(revisionNo);
                            RevisionListPanel.this.swingSession.runInForeground(new Runnable(){

                                @Override
                                public void run() {
                                    if (currentVersion == -1) {
                                        JOptionPane.showMessageDialog(RevisionListPanel.this.dialogOwner, "The server did not revert because the target and current revisions are identical");
                                    } else {
                                        RevisionListPanel.this.currentVersion = currentVersion;
                                        long range = RevisionListPanel.this.toVersion.getValue() - RevisionListPanel.this.fromVersion.getValue();
                                        RevisionListPanel.this.fromVersion.setValue((long)currentVersion - range);
                                        RevisionListPanel.this.toVersion.setValue(currentVersion);
                                        RevisionListPanel.this.revisionsTable.refreshRevisionsList(RevisionListPanel.this.fromVersion.getValue(), RevisionListPanel.this.toVersion.getValue());
                                        int last = RevisionListPanel.this.revisionsTable.getRowCount() - 1;
                                        RevisionListPanel.this.revisionsTable.getSelectionModel().setSelectionInterval(last, last);
                                    }
                                }
                            });
                        }
                        catch (Throwable t) {
                            throw new RuntimeException("Error requesting server revert", t);
                        }
                        finally {
                            RevisionListPanel.this.refreshPanel();
                        }
                    }
                });
            }
        }
    };
    private final Action openAction = new AbstractAction("Open..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            int revisionNo = RevisionListPanel.this.revisionsTable.getSelectedRevisionNumber();
            ProjectLocation location = RevisionListPanel.this.session.getProjectLocation();
            ArchitectSwingSession revisionSession = null;
            try {
                revisionSession = RevisionListPanel.this.swingSession.getContext().createSession();
                revisionSession.getUndoManager().setLoading(true);
                revisionSession.setName(location.getName() + " - Revision " + revisionNo);
                ArchitectSessionPersister sessionPersister = new ArchitectSessionPersister("inbound-" + location.getUUID(), (SPObject)revisionSession.getWorkspace(), new ArchitectPersisterSuperConverter(revisionSession.getDataSources(), (SPObject)revisionSession.getWorkspace()));
                sessionPersister.setWorkspaceContainer(revisionSession);
                SPJSONMessageDecoder decoder = new SPJSONMessageDecoder((SPPersister)sessionPersister);
                RevisionListPanel.this.session.persistRevisionFromServer(revisionNo, decoder);
                revisionSession.getUndoManager().setLoading(false);
                RevisionListPanel.this.swingSession.getArchitectFrame().addSession(revisionSession);
            }
            catch (Exception ex) {
                if (revisionSession != null) {
                    revisionSession.close();
                }
                throw new RuntimeException(ex);
            }
        }
    };
    private final Action compareAction = new AbstractAction("Compare..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)RevisionListPanel.this.swingSession.getArchitectFrame(), (String)"Compare Revisions");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            CompareRevisionsPanel p = new CompareRevisionsPanel(RevisionListPanel.this.session, closeAction, RevisionListPanel.this.fromVersion.getValue(), RevisionListPanel.this.toVersion.getValue());
            d.setDefaultCloseOperation(2);
            d.setContentPane(p.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(RevisionListPanel.this.getPanel());
            d.setVisible(true);
        }
    };

    public RevisionListPanel(ArchitectSwingSession swingSession, ArchitectFrame architectFrame, Action closeAction) {
        this.dialogOwner = architectFrame;
        this.swingSession = swingSession;
        this.session = swingSession.getEnterpriseSession();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("default:grow, 5dlu, pref", "pref, 2dlu, default:grow"));
        int currentRevision = this.session.getUpdater().getRevision();
        long from = currentRevision - 100;
        if (from <= 0L) {
            from = 1L;
        }
        this.fromVersion = new JLongField(from);
        this.toVersion = new JLongField(currentRevision);
        this.revisionsTable = new RevisionsTable(this.session, from, currentRevision);
        this.revisionsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RevisionListPanel.this.refreshPanel();
            }
        });
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel("Revisions:"), cc.xy(1, 1));
        builder.add((Component)this.revisionsTable.getScrollPane(), cc.xy(1, 3));
        DefaultFormBuilder textFieldBuilder = new DefaultFormBuilder(new FormLayout("pref, pref"));
        textFieldBuilder.append((Component)new JLabel("from version "), (Component)this.fromVersion.getField());
        textFieldBuilder.append((Component)new JLabel("to version "), (Component)this.toVersion.getField());
        DefaultFormBuilder filterBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        filterBuilder.append((Component)new JLabel("Display revisions "));
        filterBuilder.append((Component)textFieldBuilder.getPanel());
        this.autoRefreshBox = new JCheckBox("Auto-refresh", false);
        this.autoRefresh = new Runnable(){

            @Override
            public void run() {
                while (RevisionListPanel.this.autoRefreshBox.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RevisionListPanel.this.refreshAction.actionPerformed(null);
                        }
                    });
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        RevisionListPanel.this.autoRefreshBox.setSelected(false);
                    }
                }
            }
        };
        this.autoRefreshBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (RevisionListPanel.this.autoRefreshBox.isSelected()) {
                    new Thread(RevisionListPanel.this.autoRefresh).start();
                }
            }
        });
        this.autoRefreshBox.setSelected(true);
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)filterBuilder.getPanel());
        buttonBarBuilder.append((Component)new JLabel("\n"));
        buttonBarBuilder.append((Component)new JButton(this.refreshAction));
        buttonBarBuilder.append((Component)new JButton(this.revertAction));
        buttonBarBuilder.append((Component)new JButton(this.openAction));
        buttonBarBuilder.append((Component)new JButton(this.compareAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        buttonBarBuilder.append((Component)this.autoRefreshBox);
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(3, 3));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
        this.panel.setPreferredSize(new Dimension(700, 500));
        this.refreshPanel();
    }

    private void refreshPanel() {
        if (this.revisionsTable.getSelectedRow() == -1) {
            this.openAction.setEnabled(false);
            this.revertAction.setEnabled(false);
        } else {
            this.openAction.setEnabled(true);
            this.revertAction.setEnabled(true);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private class JLongField {
        private JFormattedTextField field;
        private long value;

        public JLongField(long value) {
            NumberFormatter f = new NumberFormatter(NumberFormat.getInstance());
            f.setValueClass(Long.class);
            f.setMinimum(new Long(1L));
            this.field = new JFormattedTextField(f);
            this.setValue(value);
        }

        public void setValue(long value) {
            this.value = value;
            this.field.setValue(new Long(value));
        }

        public long getValue() {
            return this.getValue(true);
        }

        public long getValue(boolean update) {
            if (update) {
                this.value = (Long)this.field.getValue();
            }
            return this.value;
        }

        public JFormattedTextField getField() {
            return this.field;
        }

        public boolean update() {
            return this.value != this.getValue(true);
        }
    }
}

