/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import java.util.ArrayList;
import java.util.List;

public class ZeroTransformer
extends StatedTransformer {
    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        ArrayList<AssignStmt> assignStmtList = new ArrayList<AssignStmt>();
        for (Stmt p = method.stmts.getFirst(); p != null; p = p.getNext()) {
            int v;
            if (p.st != Stmt.ST.ASSIGN) continue;
            AssignStmt as = (AssignStmt)p;
            if (as.getOp1().vt != Value.VT.LOCAL || as.getOp2().vt != Value.VT.CONSTANT) continue;
            Constant cst = (Constant)as.getOp2();
            Object value = cst.value;
            if (!(value instanceof Number) || value instanceof Long || value instanceof Double || (v = ((Number)value).intValue()) != 0 && v != 1) continue;
            assignStmtList.add(as);
        }
        if (assignStmtList.size() == 0) {
            return false;
        }
        List<LabelStmt> phiLabels = method.phiLabels;
        if (phiLabels != null) {
            for (AssignStmt as : assignStmtList) {
                Local local = (Local)as.getOp1();
                boolean first = true;
                for (LabelStmt labelStmt : phiLabels) {
                    for (AssignStmt phi : labelStmt.phis) {
                        Value[] vs = phi.getOp2().getOps();
                        for (int i = 0; i < vs.length; ++i) {
                            Value v = vs[i];
                            if (v != local) continue;
                            if (first) {
                                first = false;
                                continue;
                            }
                            Local nLocal = Exprs.nLocal(-1);
                            method.locals.add(nLocal);
                            changed = true;
                            method.stmts.insertBefore(as, Stmts.nAssign(nLocal, as.getOp2().clone()));
                            vs[i] = nLocal;
                        }
                    }
                }
            }
        }
        return changed;
    }
}

