/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class MonitorInstances
extends BaseCmd {
    private String[] instanceIds;

    public MonitorInstances(String name, String alias, String[] args) {
        super(name, alias);
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    public MonitorInstances(String[] args) {
        this("ec2min", "ec2-monitor-instances", args);
    }

    @Override
    protected String getOptionString() {
        return "[INSTANCE [INSTANCE [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        this.printMonitoringDescription();
    }

    protected void printMonitoringDescription() {
        System.out.println("     Monitor selected running or pending instances.");
        System.out.println("     The INSTANCE parameter is an instance ID to monitor.");
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        if (this.cmd == null) {
            return;
        }
        this.instanceIds = this.getNonOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair<List<MonitorInstance>> rsp = this.monitorChangeCall(jec2);
        for (MonitorInstance instance : (List)rsp.getResponse()) {
            out.output(System.out, instance);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        if (this.instanceIds == null || this.instanceIds.length == 0) {
            throw new GeneralError("Need at least one instance id");
        }
    }

    protected RequestResultPair<List<MonitorInstance>> monitorChangeCall(Jec2 jec2) throws Exception {
        return jec2.monitorInstances(this.getInstanceIds());
    }

    public String[] getInstanceIds() {
        return this.instanceIds;
    }

    public static void main(String[] args) {
        new MonitorInstances(args).invoke();
    }
}

