/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;

public final class MiniMap
extends JPanel
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(MiniMap.class.getName());
    public static final int MAX_TILE_SIZE = 24;
    public static final int MIN_TILE_SIZE = 4;
    public static final int SCALE_STEP = 4;
    private final FreeColClient freeColClient;
    private int tileSize;
    private PrerenderedMinimap prerenderedMinimap = null;
    private volatile boolean dirty = true;
    private MinimapPainterThread minimapPainterThread = new MinimapPainterThread();

    public MiniMap(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.setLayout(null);
        this.tileSize = 4 * freeColClient.getClientOptions().getInteger("model.option.defaultZoomLevel");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.minimapPainterThread.start();
        this.minimapPainterThread.setPriority(4);
        this.setOpaque(false);
    }

    private GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    private Game getGame() {
        return this.freeColClient.getGame();
    }

    private Map getMap() {
        Game game = this.getGame();
        return game == null ? null : game.getMap();
    }

    private void setZoomOption(int tileSize) {
        int zoom = tileSize / 4;
        this.freeColClient.getClientOptions().setInteger("model.option.defaultZoomLevel", zoom);
    }

    private void setFocus(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        Map map = this.getMap();
        if (map == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Dimension size = this.getSize();
        Point focusPoint = this.getGUI().getFocusMapPoint();
        Dimension mapTileSize = this.getGUI().getScaledImageLibrary().scale(ImageLibrary.TILE_SIZE);
        int mapPointX = focusPoint.x + mapTileSize.width * (x - size.width / 2) / this.tileSize;
        int mapPointY = focusPoint.y + mapTileSize.height * (y - size.height / 2) / (this.tileSize / 2);
        this.getGUI().setFocusMapPoint(new Point(mapPointX, mapPointY));
    }

    private void recreateBufferImage() {
        Map map = this.getMap();
        if (map == null) {
            this.prerenderedMinimap = null;
            return;
        }
        int theTileSize = this.tileSize;
        Dimension size = new Dimension(theTileSize * map.getWidth() + theTileSize / 2, theTileSize * map.getHeight() / 2 + theTileSize / 4);
        BufferedImage nextPaintedMinimapImage = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleImage(size.width, size.height, 1);
        Graphics2D g2d = nextPaintedMinimapImage.createGraphics();
        this.paintEntireMinimap(g2d, theTileSize, size);
        g2d.dispose();
        this.prerenderedMinimap = new PrerenderedMinimap(nextPaintedMinimapImage, theTileSize);
    }

    public void updateCachedMinimap() {
        this.dirty = true;
        LockSupport.unpark(this.minimapPainterThread);
    }

    public void zoomIn() {
        this.tileSize = Math.min(this.tileSize + 4, 24);
        this.setZoomOption(this.tileSize);
        this.updateCachedMinimap();
    }

    public void zoomOut() {
        this.tileSize = Math.max(this.tileSize - 4, 4);
        this.setZoomOption(this.tileSize);
        this.updateCachedMinimap();
    }

    public boolean canZoomIn() {
        return this.tileSize < 24 && this.getMap() != null;
    }

    public boolean canZoomOut() {
        return this.tileSize > 4 && this.getMap() != null;
    }

    public void setTileSize(int size) {
        this.tileSize = Math.max(Math.min(size, 24), 4);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public void paintMap(Graphics2D g2d) {
        if (this.getMap() == null) {
            return;
        }
        Point focusPoint = this.getGUI().getFocusMapPoint();
        if (focusPoint == null) {
            return;
        }
        Dimension size = this.getSize();
        g2d.setColor(ImageLibrary.getMinimapBackgroundColor());
        g2d.fillRect(0, 0, size.width, size.height);
        PrerenderedMinimap thePrerenderedMinimap = this.prerenderedMinimap;
        if (thePrerenderedMinimap == null) {
            return;
        }
        int theTileSize = thePrerenderedMinimap.tileSize;
        Dimension mapTileSize = this.getGUI().getScaledImageLibrary().scale(ImageLibrary.TILE_SIZE);
        int x = -focusPoint.x * theTileSize / mapTileSize.width + size.width / 2;
        int y = -focusPoint.y * (theTileSize / 2) / mapTileSize.height + size.height / 2;
        g2d.drawImage((Image)thePrerenderedMinimap.paintedMinimapImage, x, y, null);
        this.paintMarkerForVisibleAreaOnMainMap(g2d, size, theTileSize, mapTileSize);
    }

    private void paintMarkerForVisibleAreaOnMainMap(Graphics2D g2d, Dimension size, int tileSize, Dimension mapTileSize) {
        Dimension actualMapViewDimension = this.getGUI().getMapViewDimension();
        if (actualMapViewDimension == null) {
            return;
        }
        int whiteRectangleWidth = (actualMapViewDimension.width / mapTileSize.width + 1) * tileSize;
        int whiteRectangleHeight = (actualMapViewDimension.height / mapTileSize.height + 1) * tileSize / 2;
        g2d.setColor(ImageLibrary.getMinimapBorderColor());
        g2d.drawRect(size.width / 2 - whiteRectangleWidth / 2, size.height / 2 - whiteRectangleHeight / 2, whiteRectangleWidth, whiteRectangleHeight);
    }

    public void paintEntireMinimap(Graphics graphics, int tileSize, Dimension size) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int minimapWidth = size.width;
        int minimapHeight = size.height;
        g.setColor(ImageLibrary.getMinimapBackgroundColor());
        g.fillRect(0, 0, minimapWidth, minimapHeight);
        Map map = this.getMap();
        int tileWidth = tileSize;
        int tileHeight = tileSize / 2;
        int halfWidth = tileSize / 2;
        int halfHeight = tileSize / 4;
        GeneralPath tilePath = new GeneralPath();
        tilePath.moveTo(halfWidth, 0.0f);
        tilePath.lineTo(tileWidth, halfHeight);
        tilePath.lineTo(halfWidth, tileHeight);
        tilePath.lineTo(0.0f, halfHeight);
        tilePath.closePath();
        GeneralPath settlementPath = new GeneralPath(tilePath);
        settlementPath.transform(AffineTransform.getScaleInstance(0.7, 0.7));
        settlementPath.transform(AffineTransform.getTranslateInstance(0.15 * (double)tileWidth, 0.15 * (double)tileHeight));
        GeneralPath unitPath = new GeneralPath(tilePath);
        unitPath.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        unitPath.transform(AffineTransform.getTranslateInstance(0.25 * (double)tileWidth, 0.25 * (double)tileHeight));
        GeneralPath paintFull = new GeneralPath(tilePath);
        paintFull.transform(AffineTransform.getScaleInstance(1.0, 1.0));
        g.setStroke(new BasicStroke(1.0f));
        ClientOptions clientOptions = this.freeColClient.getClientOptions();
        List<Tile> subMap = map.subMap(0, 0, map.getWidth(), map.getHeight());
        Tile firstTile = subMap.get(0);
        MiniMap.paintEachTile(g, firstTile, tileSize, subMap, (tileG2d, tile) -> {
            if (tile.isExplored()) {
                if (clientOptions.getBoolean("model.option.miniMapToggleBorders")) {
                    g.setColor(ImageLibrary.getMinimapPoliticsColor(tile.getType()));
                    g.fill(tilePath);
                    if (tile.getOwner() != null) {
                        Color nationOwner = tile.getOwner().getNationColor();
                        Color colorTransparent = new Color(nationOwner.getRed(), nationOwner.getGreen(), nationOwner.getBlue(), 100);
                        g.setColor(colorTransparent);
                        g.fill(paintFull);
                    }
                } else {
                    g.setColor(ImageLibrary.getMinimapEconomicColor(tile.getType()));
                    g.fill(tilePath);
                }
                if (!tile.hasSettlement()) {
                    Unit unit = tile.getFirstUnit();
                    if (unit != null) {
                        g.setColor(Color.BLACK);
                        g.draw(unitPath);
                        g.setColor(unit.getOwner().getNationColor());
                        g.fill(unitPath);
                    }
                } else {
                    g.setColor(Color.BLACK);
                    g.draw(settlementPath);
                    g.setColor(tile.getSettlement().getOwner().getNationColor());
                    g.fill(settlementPath);
                }
                if (!this.freeColClient.isMapEditor() && this.freeColClient.getMyPlayer() != null && !this.freeColClient.getMyPlayer().canSee(tile) && clientOptions.getBoolean("model.option.miniMapToggleFogOfWar")) {
                    Color blackTransparent = new Color(0, 0, 0, 100);
                    g.setColor(blackTransparent);
                    g.fill(paintFull);
                }
            }
        });
    }

    private static void paintEachTile(Graphics2D g2d, Tile firstTile, int tileSize, List<Tile> tiles, TileRenderingCallback c) {
        if (tiles.isEmpty()) {
            return;
        }
        int x0 = firstTile.getX();
        int y0 = firstTile.getY();
        int width = tileSize;
        int halfWidth = tileSize / 2;
        int halfHeight = tileSize / 4;
        int xt0 = 0;
        int yt0 = 0;
        for (Tile t : tiles) {
            int x = t.getX();
            int y = t.getY();
            int xt = (x - x0) * width + (y & 1) * halfWidth;
            int yt = (y - y0) * halfHeight;
            g2d.translate(xt - xt0, yt - yt0);
            xt0 = xt;
            yt0 = yt;
            c.render(g2d, t);
        }
        g2d.translate(-xt0, -yt0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setFocus(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setFocus(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getMap() == null) {
            return;
        }
        graphics.drawImage(ImageLibrary.getMiniMapBackground(), 0, 0, null);
        this.paintMap((Graphics2D)graphics);
    }

    private final class MinimapPainterThread
    extends Thread {
        private MinimapPainterThread() {
        }

        @Override
        public void run() {
            block0: while (true) {
                MiniMap.this.recreateBufferImage();
                MiniMap.this.dirty = false;
                while (true) {
                    if (MiniMap.this.dirty) continue block0;
                    LockSupport.park();
                }
                break;
            }
        }
    }

    private static final class PrerenderedMinimap {
        private final BufferedImage paintedMinimapImage;
        private final int tileSize;

        private PrerenderedMinimap(BufferedImage paintedMinimapImage, int tileSize) {
            this.paintedMinimapImage = paintedMinimapImage;
            this.tileSize = tileSize;
        }
    }

    private static interface TileRenderingCallback {
        public void render(Graphics2D var1, Tile var2);
    }
}

