/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class HighScoresMessage
extends ObjectMessage {
    public static final String TAG = "highScores";
    private static final String KEY_TAG = "key";

    public HighScoresMessage(String key, List<HighScore> scores) {
        super(TAG, KEY_TAG, key);
        this.appendChildren(scores);
    }

    public HighScoresMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, KEY_TAG);
        ArrayList<HighScore> scores = new ArrayList<HighScore>();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("highScore".equals(tag)) {
                scores.add(new HighScore(xr));
            } else {
                this.expected("highScore", tag);
            }
            xr.expectTag(tag);
        }
        xr.expectTag(TAG);
        this.appendChildren(scores);
    }

    private String getKey() {
        return this.getStringAttribute(KEY_TAG);
    }

    private List<HighScore> getScores() {
        return this.getChildren(HighScore.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        String key = this.getKey();
        List<HighScore> scores = this.getScores();
        this.igc(freeColClient).highScoresHandler(key, scores);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.igc(freeColServer).getHighScores(serverPlayer, this.getKey());
    }
}

