/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class SetCurrentPlayerMessage
extends AttributeMessage {
    public static final String TAG = "setCurrentPlayer";
    private static final String PLAYER_TAG = "player";

    public SetCurrentPlayerMessage(Player player) {
        super(TAG, PLAYER_TAG, player.getId());
    }

    public SetCurrentPlayerMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        Player currentPlayer = this.getPlayer(freeColServer.getGame());
        if (currentPlayer == null) {
            return;
        }
        aiPlayer.setCurrentPlayerHandler(currentPlayer);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) throws FreeColException {
        Game game = freeColClient.getGame();
        Player player = this.getPlayer(game);
        if (player == null) {
            throw new FreeColException("Invalid player: " + this.getStringAttribute(PLAYER_TAG));
        }
        this.igc(freeColClient).setCurrentPlayerHandler(player);
        this.clientGeneric(freeColClient);
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }
}

