/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.FountainOfYouthMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TurnTaker;

public class ServerUnit
extends Unit
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerUnit.class.getName());

    public ServerUnit(Game game, String id) {
        super(game, id);
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type) {
        this(game, location, owner, type, type.getDefaultRole());
    }

    public ServerUnit(Game game, Location location, Unit template) {
        this(game, location, game.getPlayerByNationId(template.getOwner().getNationId()), game.getSpecification().getUnitType(template.getType().getId()), game.getSpecification().getDefaultRole());
        Specification spec = this.getSpecification();
        if (template.getName() != null) {
            this.setName(template.getName());
        }
        this.setNationality(template.getNationality());
        this.setEthnicity(template.getEthnicity());
        this.workLeft = template.getWorkLeft();
        this.workType = spec.getGoodsType(template.getWorkType().getId());
        this.movesLeft = template.getMovesLeft();
        this.hitPoints = template.getType().getHitPoints();
        this.changeRole(spec.getRole(template.getRole().getId()), template.getRoleCount());
        this.setStateUnchecked(template.getState());
        if (this.getType().canCarryGoods()) {
            this.setGoodsContainer(new GoodsContainer(game, this));
        }
        this.visibleGoodsCount = -1;
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type, Role role) {
        super(game);
        this.owner = owner;
        this.type = type;
        this.state = Unit.UnitState.ACTIVE;
        this.role = this.getSpecification().getDefaultRole();
        this.location = null;
        this.entryLocation = null;
        this.workLeft = -1;
        this.workType = null;
        this.movesLeft = this.getInitialMovesLeft();
        this.experienceType = null;
        this.experience = 0;
        this.workImprovement = null;
        this.teacher = null;
        this.student = null;
        this.turnsOfTraining = 0;
        this.indianSettlement = null;
        this.destination = null;
        this.tradeRoute = null;
        this.currentStop = -1;
        this.treasureAmount = 0;
        this.attrition = 0;
        this.visibleGoodsCount = -1;
        UnitTypeChange uc = this.getUnitChange("model.unitChange.creation");
        if (uc != null) {
            this.type = uc.to;
        }
        if (this.type.hasAbility("model.ability.person")) {
            this.ethnicity = this.nationality = owner.getNationId();
        } else {
            this.nationality = null;
            this.ethnicity = null;
        }
        this.hitPoints = this.type.getHitPoints();
        this.changeRole(role, role.getMaximumCount());
        this.setStateUnchecked(this.state);
        this.setLocation(location);
        if (this.getType().canCarryGoods()) {
            this.setGoodsContainer(new GoodsContainer(game, this));
        }
        this.owner.addUnit(this);
    }

    private void csImproveTile(Random random, ChangeSet cs) {
        TileImprovementType tileImprovementType;
        int exposeResource;
        TileImprovement ti;
        TileType changeType;
        Tile tile = this.getTile();
        tile.cacheUnseen();
        AbstractGoods deliver = this.getWorkImprovement().getType().getProduction(tile.getType());
        if (deliver != null) {
            Turn turn = this.getGame().getTurn();
            int amount = deliver.getAmount();
            amount = (int)this.apply(amount, turn, "model.modifier.tileTypeChangeProduction", deliver.getType());
            Settlement settlement = tile.getOwningSettlement();
            if (settlement != null && this.owner.owns(settlement)) {
                amount = (int)settlement.apply(amount, turn, "model.modifier.tileTypeChangeProduction", deliver.getType());
                settlement.addGoods(deliver.getType(), amount);
            }
        }
        if ((changeType = (ti = this.getWorkImprovement()).getChange(tile.getType())) != null) {
            tile.changeType(changeType);
        }
        if ((exposeResource = (tileImprovementType = ti.getType()).getExposeResourcePercent()) > 0 && !tile.hasResource() && RandomUtils.randomInt(logger, "Expose resource", random, 100) < exposeResource) {
            int maxValue;
            int minValue;
            ResourceType resType = (ResourceType)RandomChoice.getWeightedRandom(logger, "Resource type", tile.getType().getResourceTypes(), random);
            int value = minValue + ((minValue = resType.getMinValue()) == (maxValue = resType.getMaxValue()) ? 0 : RandomUtils.randomInt(logger, "Resource quantity", random, maxValue - minValue + 1));
            tile.addResource(new Resource(this.getGame(), tile, resType, value));
        }
        if (this.changeRoleCount(-ti.getType().getExpendedAmount())) {
            Player owner = this.getOwner();
            StringTemplate locName = this.getLocation().getLocationLabelFor(owner);
            Object messageId = this.getType() + ".noMoreTools";
            if (!Messages.containsKey((String)messageId)) {
                messageId = "model.unit.noMoreTools";
            }
            cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, (String)messageId, this).addStringTemplate("%unit%", this.getLabel())).addStringTemplate("%location%", locName));
        }
        for (Unit unit : CollectionUtils.transform(tile.getUnits(), u -> u.getWorkImprovement() != null && u.getWorkImprovement().getType() == ti.getType() && u.getState() == Unit.UnitState.IMPROVING)) {
            unit.setWorkLeft(-1);
            unit.setWorkImprovement(null);
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
        }
    }

    public void csEmbark(Unit carrier, ChangeSet cs) {
        Colony colony;
        Player owner = this.getOwner();
        Location oldLocation = this.getLocation();
        Colony colony2 = colony = oldLocation instanceof WorkLocation ? this.getColony() : null;
        if (colony != null) {
            oldLocation.getTile().cacheUnseen();
        }
        this.setLocation(carrier);
        this.setMovesLeft(0);
        cs.add(ChangeSet.See.only(owner), colony != null ? colony : (FreeColGameObject)((Object)oldLocation));
        if (carrier.getLocation() != oldLocation) {
            cs.add(ChangeSet.See.only(owner), carrier);
        }
        if (oldLocation instanceof Tile) {
            Tile tile = carrier.getTile();
            if (tile != oldLocation) {
                cs.addMove(ChangeSet.See.only(owner), this, oldLocation, tile);
                owner.invalidateCanSeeTiles();
            }
            cs.addDisappear(owner, (Tile)oldLocation, this);
        }
    }

    public void csRepairUnit(ChangeSet cs) {
        Player owner = this.getOwner();
        this.setHitPoints(this.getHitPoints() + 1);
        if (!this.isDamaged()) {
            Location loc = Location.upLoc(this.getLocation());
            cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_REPAIRED, "model.unit.unitRepaired", this, (FreeColGameObject)((Object)loc)).addStringTemplate("%unit%", this.getLabel())).addStringTemplate("%repairLocation%", loc.getLocationLabelFor(owner)));
            this.setState(Unit.UnitState.ACTIVE);
        }
        cs.addPartial(ChangeSet.See.only(owner), this, "hitPoints", String.valueOf(this.getHitPoints()));
    }

    private Unit getSlowedBy(Tile newTile, Random random) {
        Player player = this.getOwner();
        Game game = this.getGame();
        CombatModel combatModel = game.getCombatModel();
        boolean pirate = this.hasAbility("model.ability.piracy");
        Unit attacker = null;
        double attackPower = 0.0;
        double totalAttackPower = 0.0;
        if (!this.isNaval() || this.getMovesLeft() <= 0) {
            return null;
        }
        for (Tile tile : newTile.getSurroundingTiles(1)) {
            Player enemy;
            if (tile.isLand() || tile.getColony() != null || tile.getFirstUnit() == null || (enemy = tile.getFirstUnit().getOwner()) == player) continue;
            for (Unit enemyUnit : CollectionUtils.transform(tile.getUnits(), u -> u.isNaval() && (pirate || u.hasAbility("model.ability.piracy") || u.isOffensiveUnit() && player.atWarWith(enemy)))) {
                double power = combatModel.getOffencePower(enemyUnit, this);
                totalAttackPower += power;
                if (!(power > attackPower)) continue;
                attacker = enemyUnit;
                attackPower = power;
            }
        }
        if (attacker != null) {
            double defencePower = combatModel.getDefencePower(attacker, this);
            double totalProbability = totalAttackPower + defencePower;
            if ((double)RandomUtils.randomInt(logger, "Slowed", random, (int)Math.round(totalProbability + 1.0)) < totalAttackPower) {
                int diff = Math.max(0, (int)Math.round(totalAttackPower - defencePower));
                int moves = Math.min(9, 3 + diff / 3);
                this.setMovesLeft(this.getMovesLeft() - moves);
                logger.info(this.getId() + " slowed by " + attacker.getId() + " by " + Integer.toString(moves) + " moves.");
            } else {
                attacker = null;
            }
        }
        return attacker;
    }

    private void csNativeBurialGround(ChangeSet cs) {
        Player owner = this.getOwner();
        Tile tile = this.getTile();
        Player indianPlayer = tile.getOwner();
        ((ServerPlayer)owner).csContact(indianPlayer, cs);
        ((ServerPlayer)indianPlayer).csModifyTension(owner, Tension.Level.HATEFUL.getLimit(), cs);
        ((ServerPlayer)owner).csChangeStance(Stance.WAR, indianPlayer, true, cs);
        cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, LostCityRumour.RumourType.BURIAL_GROUND.getDescriptionKey(), owner, this).addStringTemplate("%nation%", indianPlayer.getNationLabel()));
    }

    private boolean csExploreLostCityRumour(Random random, ChangeSet cs) {
        boolean mounds;
        Player owner = this.getOwner();
        Tile tile = this.getTile();
        LostCityRumour lostCity = tile.getLostCityRumour();
        if (lostCity == null) {
            return true;
        }
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        int difficulty = spec.getInteger("model.option.rumourDifficulty");
        int dx = 10 - difficulty;
        ServerUnit newUnit = null;
        List<UnitType> treasureUnitTypes = spec.getUnitTypesWithAbility("model.ability.carryTreasure");
        LostCityRumour.RumourType rumour = lostCity.getType();
        if (rumour == null) {
            rumour = lostCity.chooseType(this, random);
        }
        switch (rumour) {
            case BURIAL_GROUND: 
            case MOUNDS: {
                if (tile.getOwner() != null && tile.getOwner().isIndian()) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
            case LEARN: {
                if (this.getUnitChange("model.unitChange.lostCity") == null) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
        }
        boolean bl = mounds = rumour == LostCityRumour.RumourType.MOUNDS;
        if (mounds) {
            boolean done = false;
            boolean nothing = false;
            block21: while (!done) {
                rumour = lostCity.chooseType(this, random);
                switch (rumour) {
                    case NOTHING: {
                        if (nothing) {
                            done = true;
                            continue block21;
                        }
                        nothing = true;
                        continue block21;
                    }
                    case EXPEDITION_VANISHES: 
                    case TRIBAL_CHIEF: {
                        done = true;
                        continue block21;
                    }
                    case RUINS: {
                        done = true;
                        if (RandomUtils.randomInt(logger, "Ruins+Burial", random, 100) >= spec.getPercentage("model.option.badRumour")) continue block21;
                    }
                    case BURIAL_GROUND: {
                        done = tile.getOwner() != null && tile.getOwner().isIndian();
                        continue block21;
                    }
                }
            }
        }
        logger.info("Unit " + this.getId() + " is exploring rumour " + rumour);
        boolean result = true;
        String key = rumour.getDescriptionKey();
        switch (rumour) {
            case BURIAL_GROUND: {
                this.csNativeBurialGround(cs);
                break;
            }
            case EXPEDITION_VANISHES: {
                cs.addMessage(owner, new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner));
                result = false;
                break;
            }
            case NOTHING: {
                cs.addMessage(owner, lostCity.getNothingMessage(owner, mounds, random));
                break;
            }
            case LEARN: {
                StringTemplate oldName = this.getLabel();
                UnitTypeChange uc = RandomUtils.getRandomMember(logger, "Choose learn", spec.getUnitChanges("model.unitChange.lostCity", this.getType()), random);
                this.changeType(uc.to);
                owner.invalidateCanSeeTiles();
                cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, this).addStringTemplate("%unit%", oldName)).addNamed("%type%", this.getType()));
                break;
            }
            case TRIBAL_CHIEF: {
                int chiefAmount = RandomUtils.randomInt(logger, "Chief base amount", random, dx * 10) + dx * 5;
                owner.modifyGold(chiefAmount);
                cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()), "score", String.valueOf(owner.getScore()));
                if (mounds) {
                    key = rumour.getAlternateDescriptionKey("mounds");
                }
                cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, this).addAmount("%money%", chiefAmount));
                owner.invalidateCanSeeTiles();
                break;
            }
            case COLONIST: {
                List<UnitType> foundTypes = spec.getUnitTypesWithAbility("model.ability.foundInLostCity");
                UnitType unitType = RandomUtils.getRandomMember(logger, "Choose found", foundTypes, random);
                newUnit = new ServerUnit(game, tile, owner, unitType);
                cs.addMessage(owner, new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, newUnit));
                break;
            }
            case CIBOLA: {
                String cityName = NameCache.getNextCityOfCibola();
                if (cityName != null) {
                    int treasureAmount = RandomUtils.randomInt(logger, "Base treasure amount", random, dx * 600) + dx * 300;
                    UnitType unitType = RandomUtils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, owner, unitType);
                    newUnit.setTreasureAmount(treasureAmount);
                    cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, newUnit).addName("%city%", cityName)).addAmount("%money%", treasureAmount));
                    cs.addGlobalHistory(game, (HistoryEvent)((StringTemplate)((StringTemplate)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.CITY_OF_GOLD, owner).addStringTemplate("%nation%", owner.getNationLabel())).addName("%city%", cityName)).addAmount("%treasure%", treasureAmount));
                    break;
                }
            }
            case RUINS: {
                int ruinsAmount = RandomUtils.randomInt(logger, "Base ruins amount", random, dx * 2) * 300 + 50;
                if (ruinsAmount < 500) {
                    owner.modifyGold(ruinsAmount);
                    cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()), "score", String.valueOf(owner.getScore()));
                } else {
                    UnitType unitType = RandomUtils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, owner, unitType);
                    newUnit.setTreasureAmount(ruinsAmount);
                }
                if (mounds) {
                    key = rumour.getAlternateDescriptionKey("mounds");
                }
                cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, newUnit != null ? newUnit : this).addAmount("%money%", ruinsAmount));
                break;
            }
            case FOUNTAIN_OF_YOUTH: {
                ServerEurope europe = (ServerEurope)owner.getEurope();
                if (europe == null) {
                    cs.addMessage(owner, new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, rumour.getAlternateDescriptionKey("noEurope"), owner, this));
                    break;
                }
                if (owner.isAI()) {
                    europe.generateFountainRecruits(dx, random);
                    cs.add(ChangeSet.See.only(owner), europe);
                } else {
                    ((ServerPlayer)owner).setRemainingEmigrants(dx);
                    cs.add(ChangeSet.See.only(owner), new FountainOfYouthMessage(dx));
                }
                cs.addMessage(owner, new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, key, owner, this));
                cs.addAttribute(ChangeSet.See.only(owner), "sound", "sound.event.fountainOfYouth");
                break;
            }
            default: {
                logger.warning("Bogus rumour type: " + rumour);
            }
        }
        tile.cacheUnseen();
        tile.removeLostCityRumour();
        return result;
    }

    public void csNewContactCheck(Tile newTile, boolean firstLanding, ChangeSet cs) {
        Player owner = this.getOwner();
        HashSet<ServerPlayer> pending = new HashSet<ServerPlayer>();
        for (Tile t : CollectionUtils.transform(newTile.getSurroundingTiles(1, 1), nt -> nt != null && nt.isLand())) {
            IndianSettlement is;
            Settlement settlement = t.getSettlement();
            Unit unit = null;
            ServerPlayer other = settlement != null ? (ServerPlayer)settlement.getOwner() : ((unit = t.getFirstUnit()) != null ? (ServerPlayer)unit.getOwner() : null);
            if (other == null || other == owner || pending.contains(other)) continue;
            if (((ServerPlayer)owner).csContact(other, cs)) {
                pending.add(other);
                if (owner.isEuropean()) {
                    if (other.isIndian()) {
                        Tile offer = firstLanding && other.owns(newTile) ? newTile : null;
                        ((ServerPlayer)owner).csNativeFirstContact(other, offer, cs);
                    } else {
                        ((ServerPlayer)owner).csEuropeanFirstContact(this, settlement, unit, cs);
                    }
                } else if (!other.isIndian()) {
                    other.csNativeFirstContact(owner, null, cs);
                }
            }
            Player contactPlayer = owner;
            IndianSettlement indianSettlement = is = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
            if (is != null || unit != null && (is = unit.getHomeIndianSettlement()) != null || unit != null && (contactPlayer = unit.getOwner()).isEuropean() && (is = this.getHomeIndianSettlement()) != null && is.getTile() != null) {
                Tile copied = is.getTile().getTileToCache();
                if (contactPlayer.hasExplored(is.getTile()) && is.setContacted(contactPlayer)) {
                    is.getTile().cacheUnseen(copied);
                    cs.add(ChangeSet.See.only(contactPlayer), is);
                    StringTemplate nation = is.getOwner().getNationLabel();
                    cs.addMessage(contactPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.nativeSettlementContact", this, is).addStringTemplate("%nation%", nation)).addName("%settlement%", is.getName()));
                    logger.finest("First contact between " + contactPlayer.getId() + " and " + is + " at " + newTile);
                }
            }
            this.csActivateSentries(t, cs);
        }
    }

    private void csActivateSentries(Tile tile, ChangeSet cs) {
        for (Unit u : CollectionUtils.transform(tile.getUnits(), CollectionUtils.matchKey(Unit.UnitState.SENTRY, Unit::getState))) {
            u.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps(), u);
        }
    }

    public void csMove(Tile newTile, Random random, ChangeSet cs) {
        Unit slowedBy;
        Player owner = this.getOwner();
        Location oldLocation = this.getLocation();
        if (oldLocation == null) {
            logger.warning("Unit with null location: " + this.toString());
            return;
        }
        Set<Tile> oldTiles = this.getVisibleTileSet();
        Set<Tile> newTiles = ((ServerPlayer)owner).collectNewTiles(newTile, this.getLineOfSight());
        this.setState(Unit.UnitState.ACTIVE);
        this.setStateToAllChildren(Unit.UnitState.SENTRY);
        if (!(oldLocation instanceof HighSeas)) {
            if (oldLocation instanceof Unit) {
                this.setMovesLeft(0);
            } else {
                if (this.getMoveCost(newTile) <= 0) {
                    logger.warning("Move of unit: " + this.getId() + " from: " + oldLocation.getTile().getId() + " to: " + newTile.getId() + " has bogus cost: " + this.getMoveCost(newTile));
                    this.setMovesLeft(0);
                }
                this.setMovesLeft(this.getMovesLeft() - this.getMoveCost(newTile));
            }
        }
        if (oldLocation instanceof WorkLocation) {
            oldLocation.getTile().cacheUnseen();
        }
        this.setLocation(newTile);
        if (newTile.hasLostCityRumour() && owner.isEuropean() && !this.csExploreLostCityRumour(random, cs)) {
            this.csRemove(ChangeSet.See.perhaps().always(owner), oldLocation, cs);
        }
        owner.invalidateCanSeeTiles();
        CollectionUtils.removeInPlace(oldTiles, t -> owner.canSee((Tile)t));
        if (!oldTiles.isEmpty()) {
            cs.add(ChangeSet.See.only(owner), oldTiles);
        }
        if (oldLocation.getTile() != null) {
            cs.addMove(ChangeSet.See.perhaps().always(owner), this, oldLocation, newTile);
            cs.add(ChangeSet.See.perhaps().always(owner), (FreeColGameObject)((Object)oldLocation));
        } else {
            cs.add(ChangeSet.See.only(owner), (FreeColGameObject)((Object)oldLocation));
        }
        cs.add(ChangeSet.See.perhaps().always(owner), newTile);
        if (this.isDisposed()) {
            return;
        }
        ((ServerPlayer)owner).csSeeNewTiles(newTiles, cs);
        if (newTile.isLand()) {
            boolean firstLanding;
            int d;
            Iterator<Unit> settlement;
            Object unit = null;
            if ((newTile.getOwner() == null || newTile.getOwner().isEuropean() && newTile.getOwningSettlement() == null) && owner.isIndian() && (settlement = this.getHomeIndianSettlement()) != null && (d = newTile.getDistanceTo(((Settlement)((Object)settlement)).getTile())) < ((Settlement)((Object)settlement)).getRadius() + ((Settlement)((Object)settlement)).getType().getExtraClaimableRadius() && RandomUtils.randomInt(logger, "Claim tribal land", random, d + 1) == 0) {
                newTile.cacheUnseen();
                newTile.changeOwnership(owner, (Settlement)((Object)settlement));
            }
            String newLand = null;
            boolean bl = firstLanding = !owner.isNewLandNamed();
            if (firstLanding && owner.isEuropean()) {
                newLand = owner.getNameForNewLand();
                owner.setNewLandName(newLand);
                cs.add(ChangeSet.See.only(owner), new NewLandNameMessage(this, newLand));
                logger.finest("First landing for " + owner + " at " + newTile + " with " + this);
            }
            this.csNewContactCheck(newTile, firstLanding, cs);
        } else {
            for (Tile t2 : CollectionUtils.transform(newTile.getSurroundingTiles(1, 1), nt -> nt != null && !nt.isLand() && nt.getFirstUnit() != null && nt.getFirstUnit().getOwner() != owner)) {
                this.csActivateSentries(t2, cs);
            }
        }
        if (this.isCarrier() && !this.isEmpty() && newTile.getColony() != null && this.getSpecification().getBoolean("model.option.disembarkInColony")) {
            for (Unit u : this.getUnitList()) {
                ((ServerUnit)u).csMove(newTile, random, cs);
            }
            this.setMovesLeft(0);
        }
        if ((slowedBy = this.getSlowedBy(newTile, random)) != null) {
            StringTemplate enemy = slowedBy.getApparentOwnerName();
            cs.addMessage(owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.slowed", this, slowedBy).addStringTemplate("%unit%", this.getLabel(Unit.UnitLabelType.NATIONAL))).addStringTemplate("%enemyUnit%", slowedBy.getLabel(Unit.UnitLabelType.PLAIN))).addStringTemplate("%enemyNation%", enemy));
        }
        this.csCheckDiscoverRegion(newTile, cs);
    }

    public void csCheckDiscoverRegion(Tile tile, ChangeSet cs) {
        Region region = tile.getDiscoverableRegion();
        Player owner = this.getOwner();
        if (region != null && owner.isEuropean() && region.checkDiscover(this)) {
            cs.add(ChangeSet.See.only(owner), new NewRegionNameMessage(region, tile, this, owner.getNameForRegion(region)));
        }
    }

    public void csVisit(ServerPlayer serverPlayer, IndianSettlement is, int scout, ChangeSet cs) {
        Player owner = is.getOwner();
        if (serverPlayer.csContact(owner, cs)) {
            serverPlayer.csNativeFirstContact(owner, null, cs);
        }
        is.setVisited(serverPlayer);
        if (scout > 0 || scout == 0 && this.getGame().getSpecification().getBoolean("model.option.settlementActionsContactChief")) {
            is.setScouted(serverPlayer);
        }
        Tile tile = is.getTile();
        tile.seeTile(serverPlayer);
        this.csCheckDiscoverRegion(tile, cs);
    }

    public void csRemove(ChangeSet.See see, Location loc, ChangeSet cs) {
        IndianSettlement is = this.changeHomeIndianSettlement(null);
        if (is != null) {
            cs.add(ChangeSet.See.only(this.getOwner()), is);
        }
        cs.addRemove(see, loc, this);
        this.dispose();
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        int maximumExperience;
        int maxValue;
        UnitTypeChange uc;
        UnitType learn;
        GoodsType produce;
        Specification spec = this.getSpecification();
        Player owner = this.getOwner();
        Location loc = this.getLocation();
        boolean locDirty = false;
        boolean unitDirty = false;
        lb.add(this);
        if (this.getType().hasMaximumAttrition() && loc instanceof Tile && !((Tile)loc).hasSettlement()) {
            int attrition = this.getAttrition() + 1;
            this.setAttrition(attrition);
            if (attrition > this.getType().getMaximumAttrition()) {
                cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.unit.attrition", this).addStringTemplate("%unit%", this.getLabel())).addStringTemplate("%location%", loc.getLocationLabelFor(owner)));
                cs.add(ChangeSet.See.perhaps(), (Tile)loc);
                this.csRemove(ChangeSet.See.perhaps().always(owner), loc, cs);
                owner.invalidateCanSeeTiles();
                lb.add(", ");
                return;
            }
        } else {
            this.setAttrition(0);
        }
        if (this.isInColony() && (produce = this.getWorkType()) != null && (learn = spec.getExpertForProducing(produce)) != null && learn != this.getType() && (uc = this.getUnitChange("model.unitChange.experience", learn)) != null && uc.probability > 0 && (maxValue = 100 * (maximumExperience = this.getType().getMaximumExperience()) / uc.probability) > 0 && RandomUtils.randomInt(logger, "Experience", random, maxValue) < Math.min(this.getExperience(), maximumExperience)) {
            StringTemplate oldName = this.getLabel();
            this.changeType(learn);
            cs.addMessage(owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.unit.experience", this.getColony(), this).addStringTemplate("%oldName%", oldName)).addStringTemplate("%unit%", this.getLabel())).addName("%colony%", this.getColony().getName()));
            lb.add(" experience upgrade to ", this.getType());
            unitDirty = true;
        }
        if (this.isInMission()) {
            this.getTile().updateIndianSettlement(owner);
            this.setMovesLeft(0);
        } else if (this.isDamagedAndUnderForcedRepair()) {
            this.setMovesLeft(0);
        } else {
            this.setMovesLeft(this.getInitialMovesLeft());
        }
        if (this.getWorkLeft() > 0) {
            unitDirty = true;
            switch (this.getState()) {
                case IMPROVING: {
                    TileImprovement ti = this.getWorkImprovement();
                    if (ti == null || ti.isComplete()) {
                        this.setState(Unit.UnitState.ACTIVE);
                        this.setWorkLeft(-1);
                        break;
                    }
                    int amount = this.getType().hasAbility("model.ability.expertPioneer") ? 2 : 1;
                    int turns = ti.getTurnsToComplete();
                    if ((turns -= amount) < 0) {
                        turns = 0;
                    }
                    ti.setTurnsToComplete(turns);
                    this.setWorkLeft(turns);
                    if (!ti.isRoad() || !ti.isComplete()) break;
                    ti.updateRoadConnections(true);
                    for (Tile t : CollectionUtils.transform(loc.getTile().getSurroundingTiles(1, 1), Tile::hasRoad)) {
                        cs.add(ChangeSet.See.perhaps(), t);
                    }
                    locDirty = true;
                    break;
                }
                default: {
                    this.setWorkLeft(this.getWorkLeft() - 1);
                }
            }
            if (loc instanceof HighSeas && this.getOwner().isREF()) {
                this.setWorkLeft(0);
            }
        }
        if (this.getState() == Unit.UnitState.SKIPPED) {
            this.setState(Unit.UnitState.ACTIVE);
            unitDirty = true;
        }
        if (this.getWorkLeft() <= 0) {
            if (this.getLocation() instanceof HighSeas) {
                Europe europe = owner.getEurope();
                Location dst = this.getDestination();
                Location result = this.resolveDestination();
                if (result == europe) {
                    lb.add(" arrives in Europe");
                    if (this.getTradeRoute() == null) {
                        this.setDestination(null);
                        cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_ARRIVED, "model.unit.arriveInEurope", europe, this).addNamed("%europe%", europe));
                    }
                    this.setState(Unit.UnitState.ACTIVE);
                    this.setLocation(europe);
                    cs.add(ChangeSet.See.only(owner), owner.getHighSeas());
                    locDirty = true;
                } else {
                    if (!(result instanceof Tile)) {
                        logger.warning("Unit has unsupported destination: " + dst + " -> " + result);
                        result = this.getFullEntryLocation();
                    }
                    Tile tile = result.getTile().getSafeTile(owner, random);
                    lb.add(" arrives in America at ", tile);
                    if (dst != null) {
                        lb.add(" sailing for ", dst);
                        if (dst instanceof Map) {
                            this.setDestination(null);
                        }
                    }
                    this.csMove(tile, random, cs);
                    unitDirty = false;
                    locDirty = false;
                }
            } else {
                switch (this.getState()) {
                    case ACTIVE: 
                    case FORTIFIED: 
                    case SENTRY: 
                    case IN_COLONY: {
                        break;
                    }
                    case IMPROVING: {
                        this.csImproveTile(random, cs);
                        this.setWorkImprovement(null);
                        locDirty = true;
                        break;
                    }
                    case FORTIFYING: {
                        this.setState(Unit.UnitState.FORTIFIED);
                        unitDirty = true;
                        break;
                    }
                    default: {
                        lb.add(new Object[]{" work completed, bad state: ", this.getState()});
                        this.setState(Unit.UnitState.ACTIVE);
                        unitDirty = true;
                    }
                }
            }
        }
        if (locDirty) {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)this.getLocation()));
        } else if (unitDirty) {
            cs.add(ChangeSet.See.perhaps(), this);
        } else {
            cs.addPartial(ChangeSet.See.only(owner), this, "movesLeft", String.valueOf(this.getMovesLeft()));
        }
        lb.add(", ");
    }
}

