#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
# Copyright (C) 2008       Brian G. Matherly
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, see <https://www.gnu.org/licenses/>.
#

# -------------------------------------------------------------------------
#
# Standard Python modules
#
# -------------------------------------------------------------------------
import re
from ....const import GRAMPS_LOCALE as glocale

_ = glocale.translation.gettext

# -------------------------------------------------------------------------
#
# Gramps modules
#
# -------------------------------------------------------------------------
from .. import Rule


# -------------------------------------------------------------------------
#
# Typing modules
#
# -------------------------------------------------------------------------
from ....lib import Note
from ....db import Database


# -------------------------------------------------------------------------
# Notes that contain a substring or match a regular expression
# -------------------------------------------------------------------------
class MatchesRegexpOf(Rule):
    labels = [_("Text:")]
    name = _("Notes containing <text>")
    description = _(
        "Matches notes that contain a substring " "or match a regular expression"
    )
    category = _("General filters")
    allow_regex = True

    def apply_to_one(self, db: Database, note: Note) -> bool:
        """Apply the filter"""
        return self.match_substring(0, str(note.text))
