/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert;

import com.ca.commons.cbutil.CBToolBarButton;
import com.ca.commons.security.cert.CertViewer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class CertPathViewPanel
extends JPanel {
    private X509Certificate cert = null;
    private JPanel certPathPanel = new JPanel();
    private JTree certpath = new JTree();
    private CBToolBarButton viewCertButton = new CBToolBarButton("&View Certificate...", null);
    private JLabel certStatusLabel = new JLabel("Certificate status:");
    private JTextArea certStatusText = new JTextArea(2, 20);

    public CertPathViewPanel(X509Certificate cert) {
        this.cert = cert;
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(CertViewer.certIcon);
        renderer.setOpenIcon(CertViewer.certIcon);
        renderer.setClosedIcon(CertViewer.certIcon);
        this.certpath.setCellRenderer(renderer);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        TitledBorder certPathBorder = BorderFactory.createTitledBorder(etchedBorder, "Certification Path");
        this.certPathPanel.setBorder(certPathBorder);
        this.viewCertButton.setWidthHeight(110, 23);
        this.viewCertButton.setEnabled(false);
        if (cert != null) {
            String ssubject = CertViewer.getMostSignificantName(cert.getSubjectX500Principal().getName());
            String iissuer = CertViewer.getMostSignificantName(cert.getIssuerX500Principal().getName());
            DefaultMutableTreeNode issuer = new DefaultMutableTreeNode(iissuer);
            DefaultMutableTreeNode subject = new DefaultMutableTreeNode(ssubject);
            if (!iissuer.equals(ssubject)) {
                issuer.add(subject);
            }
            this.certpath.setModel(new DefaultTreeModel(issuer));
            try {
                cert.checkValidity();
                this.certStatusText.setText("This certificate is OK.");
            }
            catch (CertificateExpiredException ex) {
                this.certStatusText.setText("This certificate is expired.");
            }
            catch (CertificateNotYetValidException ex) {
                this.certStatusText.setText("This certificate is not yet valid.");
            }
        }
        this.certPathPanel.setLayout(new GridBagLayout());
        this.certPathPanel.add((Component)new JScrollPane(this.certpath), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 6, 6, 6), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.certPathPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.certStatusLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 13, 2, 11), 0, 0));
        this.add((Component)new JScrollPane(this.certStatusText), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 10, 11), 0, 0));
        this.viewCertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertPathViewPanel.this.viewCertButton_actionPerformed(e);
            }
        });
    }

    private void viewCertButton_actionPerformed(ActionEvent e) {
        System.out.println("View a certificate in certification path");
    }
}

