/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import org.jboss.logmanager.formatters.ColorMap;
import org.jboss.logmanager.formatters.FormatStringParser;
import org.jboss.logmanager.formatters.MultistepFormatter;

public class PatternFormatter
extends MultistepFormatter {
    private volatile String pattern;
    private volatile ColorMap colors;

    public PatternFormatter() {
        this.colors = ColorMap.DEFAULT_COLOR_MAP;
    }

    public PatternFormatter(String pattern) {
        super(FormatStringParser.getSteps(pattern, ColorMap.DEFAULT_COLOR_MAP));
        this.colors = ColorMap.DEFAULT_COLOR_MAP;
        this.pattern = pattern;
    }

    public PatternFormatter(String pattern, String colors) {
        ColorMap colorMap;
        this.colors = colorMap = ColorMap.create(colors);
        this.pattern = pattern;
        this.setSteps(FormatStringParser.getSteps(pattern, colorMap));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            this.setSteps(null);
        } else {
            this.setSteps(FormatStringParser.getSteps(pattern, this.colors));
        }
        this.pattern = pattern;
    }

    public void setColors(String colors) {
        ColorMap colorMap;
        this.colors = colorMap = ColorMap.create(colors);
        if (this.pattern != null) {
            this.setSteps(FormatStringParser.getSteps(this.pattern, colorMap));
        }
    }

    public String getColors() {
        return this.colors.toString();
    }
}

