/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.MultiRootPathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithParentName;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);

    @BuildStep
    void addConfiguredIndexedDependencies(IndexDependencyConfiguration config, BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        for (IndexDependencyConfiguration.IndexDependencyConfig indexDependencyConfig : config.indexDependency().values()) {
            indexDependencyBuildItemBuildProducer.produce(new IndexDependencyBuildItem(indexDependencyConfig.groupId(), indexDependencyConfig.artifactId().orElse(null), indexDependencyConfig.classifier().orElse(null)));
        }
    }

    @BuildStep
    ApplicationArchivesBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables, ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItem, List<IndexDependencyBuildItem> indexDependencyBuildItems, LiveReloadBuildItem liveReloadContext, CurateOutcomeBuildItem curateOutcomeBuildItem, ClassLoadingConfig classLoadingConfig) throws IOException {
        DirectoryPathTree tree;
        IndexCache indexCache = liveReloadContext.getContextObject(IndexCache.class);
        if (indexCache == null) {
            indexCache = new IndexCache();
            liveReloadContext.setContextObject(IndexCache.class, indexCache);
        }
        HashMap<ArtifactKey, Set<String>> removedResources = new HashMap<ArtifactKey, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : classLoadingConfig.removedResources().entrySet()) {
            removedResources.put((ArtifactKey)new GACT(entry.getKey().split(":")), entry.getValue());
        }
        removedResources.putAll(curateOutcomeBuildItem.getApplicationModel().getRemovedResources());
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(buildCloseables, appMarkers, root, additionalApplicationArchiveBuildItem, indexDependencyBuildItems, indexCache, curateOutcomeBuildItem, removedResources);
        if (root.getRootDirectories().size() == 1) {
            tree = new DirectoryPathTree((Path)root.getRootDirectories().iterator().next());
        } else {
            PathTree[] trees = new PathTree[root.getRootDirectories().size()];
            int i = 0;
            for (Path p : root.getRootDirectories()) {
                trees[i++] = new DirectoryPathTree(p);
            }
            tree = new MultiRootPathTree(trees);
        }
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), (OpenPathTree)tree, curateOutcomeBuildItem.getApplicationModel().getAppArtifact()), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(QuarkusBuildCloseablesBuildItem buildCloseables, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, ArchiveRootBuildItem root, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, List<IndexDependencyBuildItem> indexDependencyBuildItem, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<ArtifactKey, Set<String>> removedResources) throws IOException {
        ArrayList<ApplicationArchive> appArchives = new ArrayList<ApplicationArchive>();
        HashSet<Path> indexedPaths = new HashSet<Path>();
        HashSet<String> markers = new HashSet<String>(appMarkers.size() + 1);
        for (AdditionalApplicationArchiveMarkerBuildItem additionalApplicationArchiveMarkerBuildItem : appMarkers) {
            String marker = additionalApplicationArchiveMarkerBuildItem.getFile();
            markers.add(marker.endsWith("/") ? marker.substring(0, marker.length() - 1) : marker);
        }
        markers.add("META-INF/jandex.idx");
        ApplicationArchiveBuildStep.addMarkerFilePaths(markers, root, indexedPaths, appArchives, indexCache, removedResources);
        this.addIndexDependencyPaths(indexDependencyBuildItem, root, indexedPaths, appArchives, buildCloseables, indexCache, curateOutcomeBuildItem, removedResources);
        for (AdditionalApplicationArchiveBuildItem additionalApplicationArchiveBuildItem : additionalApplicationArchives) {
            for (Path apPath : additionalApplicationArchiveBuildItem.getResolvedPaths()) {
                if (root.getResolvedPaths().contains(apPath) || !indexedPaths.add(apPath)) continue;
                appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, indexCache, apPath, null, removedResources));
            }
        }
        return appArchives;
    }

    private void addIndexDependencyPaths(List<IndexDependencyBuildItem> indexDependencyBuildItems, ArchiveRootBuildItem root, Set<Path> indexedDeps, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<ArtifactKey, Set<String>> removedResources) {
        if (indexDependencyBuildItems.isEmpty()) {
            return;
        }
        HashSet<ArtifactKey> indexDependencyKeys = new HashSet<ArtifactKey>();
        HashSet<String> indexGroupIds = new HashSet<String>();
        for (IndexDependencyBuildItem indexDependencyBuildItem : indexDependencyBuildItems) {
            if (indexDependencyBuildItem.getArtifactId() != null) {
                indexDependencyKeys.add(ArtifactKey.of((String)indexDependencyBuildItem.getGroupId(), (String)indexDependencyBuildItem.getArtifactId(), (String)indexDependencyBuildItem.getClassifier(), (String)"jar"));
                continue;
            }
            indexGroupIds.add(indexDependencyBuildItem.getGroupId());
        }
        for (ResolvedDependency dep : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
            if (!dep.isRuntimeCp() || !indexDependencyKeys.contains(dep.getKey()) && !indexGroupIds.contains(dep.getGroupId())) continue;
            for (Path path : dep.getContentTree().getRoots()) {
                if (root.isExcludedFromIndexing(path) || root.getResolvedPaths().contains(path) || !indexedDeps.add(path)) continue;
                try {
                    appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, indexCache, path, dep, removedResources));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private static ApplicationArchive createApplicationArchive(QuarkusBuildCloseablesBuildItem buildCloseables, IndexCache indexCache, Path dep, ResolvedDependency resolvedDependency, Map<ArtifactKey, Set<String>> removedResources) throws IOException {
        Index index;
        DirectoryPathTree openTree;
        Set<String> removed;
        LOGGER.debugf("Indexing dependency: %s", (Object)dep);
        Set<String> set = removed = resolvedDependency != null ? removedResources.get(resolvedDependency.getKey()) : null;
        if (Files.isDirectory(dep, new LinkOption[0])) {
            openTree = new DirectoryPathTree(dep);
            index = ApplicationArchiveBuildStep.indexPathTree((PathTree)openTree, removed);
        } else {
            openTree = buildCloseables.add(PathTree.ofArchive((Path)dep).open());
            index = ApplicationArchiveBuildStep.handleJarPath(dep, indexCache, removed);
        }
        return new ApplicationArchiveImpl((IndexView)index, (OpenPathTree)openTree, resolvedDependency);
    }

    private static void addMarkerFilePaths(Set<String> applicationArchiveMarkers, ArchiveRootBuildItem root, Set<Path> indexedPaths, List<ApplicationArchive> appArchives, IndexCache indexCache, Map<ArtifactKey, Set<String>> removed) throws IOException {
        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
        HashSet<ArtifactKey> indexedElements = new HashSet<ArtifactKey>();
        for (String marker : applicationArchiveMarkers) {
            List elements = cl.getElementsWithResource(marker, false);
            if (elements.isEmpty()) continue;
            for (ClassPathElement cpe : elements) {
                ArtifactKey dependencyKey;
                if (!cpe.isRuntime() || (dependencyKey = cpe.getDependencyKey()) == null || !indexedElements.add(dependencyKey)) continue;
                cpe.apply(tree -> {
                    Path rootPath;
                    indexedPaths.addAll(tree.getOriginalTree().getRoots());
                    Path path = rootPath = tree.getOriginalTree().getRoots().size() == 1 ? (Path)tree.getOriginalTree().getRoots().iterator().next() : null;
                    if (rootPath != null && !Files.isDirectory(rootPath, new LinkOption[0])) {
                        if (root.isExcludedFromIndexing(rootPath)) {
                            return null;
                        }
                        Index index = indexCache.cache.get(rootPath);
                        if (index == null) {
                            try {
                                index = IndexingUtil.indexTree(tree, (Set)removed.get(dependencyKey));
                            }
                            catch (IOException ioe) {
                                throw new UncheckedIOException(ioe);
                            }
                            indexCache.cache.put(rootPath, index);
                        }
                        appArchives.add(new ApplicationArchiveImpl((IndexView)index, (OpenPathTree)tree, cpe.getResolvedDependency()));
                        return null;
                    }
                    ApplicationArchive archive = (ApplicationArchive)tree.apply(marker, visit -> {
                        Index index;
                        if (visit == null || root.isExcludedFromIndexing(visit.getRoot())) {
                            return null;
                        }
                        try {
                            index = ApplicationArchiveBuildStep.indexPathTree((PathTree)tree, (Set)removed.get(dependencyKey));
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        return new ApplicationArchiveImpl((IndexView)index, (OpenPathTree)tree, cpe.getResolvedDependency());
                    });
                    if (archive != null) {
                        appArchives.add(archive);
                    }
                    return null;
                });
            }
        }
    }

    private static Index indexPathTree(PathTree tree, final Set<String> removed) throws IOException {
        final Indexer indexer = new Indexer();
        tree.walk(new PathVisitor(){

            public void visitPath(PathVisit visit) {
                Path path = visit.getPath();
                Path fileName = path.getFileName();
                if (fileName == null || !fileName.toString().endsWith(".class") || Files.isDirectory(path, new LinkOption[0]) || removed != null && removed.contains(visit.getRelativePath("/"))) {
                    return;
                }
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    indexer.index(in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return indexer.complete();
    }

    private static Index handleJarPath(Path path, IndexCache indexCache, final Set<String> removed) {
        return indexCache.cache.computeIfAbsent(path, new Function<Path, Index>(){

            @Override
            public Index apply(Path path) {
                try {
                    return IndexingUtil.indexJar(path, (Set<String>)removed);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to process " + String.valueOf(path), e);
                }
            }
        });
    }

    @ConfigMapping(prefix="quarkus.index-dependency")
    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static interface IndexDependencyConfiguration {
        @WithParentName
        @ConfigDocSection
        @ConfigDocMapKey(value="dependency-name")
        public Map<String, IndexDependencyConfig> indexDependency();

        public static interface IndexDependencyConfig {
            public String groupId();

            public Optional<String> artifactId();

            public Optional<String> classifier();
        }
    }

    private static final class IndexCache {
        final Map<Path, Index> cache = new HashMap<Path, Index>();

        private IndexCache() {
        }
    }
}

