/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.Util;

public class EchoServer {
    protected ServerSocket srv_sock;
    protected ExecutorService thread_pool = Executors.newCachedThreadPool();
    protected final String name = Util.generateLocalName();

    protected void start(InetAddress bind_addr, int port) throws Exception {
        this.srv_sock = new ServerSocket(port, 50, bind_addr);
        System.out.printf("%s listening on %s\n", EchoServer.class.getSimpleName(), this.srv_sock.getLocalSocketAddress());
        while (!this.srv_sock.isClosed()) {
            try {
                Socket client_sock = this.srv_sock.accept();
                ConnectionHandler handler = new ConnectionHandler(client_sock);
                this.thread_pool.execute(handler);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.thread_pool.shutdown();
        this.thread_pool.awaitTermination(3L, TimeUnit.SECONDS);
    }

    public static void main(String[] args) throws Exception {
        InetAddress bind_addr = null;
        int port = 9000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-bind_addr")) {
                bind_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].startsWith("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("EchoServer [-bind_addr addr] [-port port] [-h]");
            return;
        }
        EchoServer es = new EchoServer();
        es.start(bind_addr, port);
    }

    protected class ConnectionHandler
    implements Runnable {
        protected final Socket client_sock;

        public ConnectionHandler(Socket client_sock) {
            this.client_sock = client_sock;
        }

        @Override
        public void run() {
            try (OutputStream output = this.client_sock.getOutputStream();){
                System.out.printf("-- connection from %s\n", this.client_sock.getRemoteSocketAddress());
                String s = String.format("%s: running on %s\nclient: %s\n", EchoServer.this.name, InetAddress.getLocalHost().getHostName(), this.client_sock.getRemoteSocketAddress());
                output.write(s.getBytes());
                output.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void _run() throws Exception {
            try (OutputStream output = this.client_sock.getOutputStream();
                 InputStream in = this.client_sock.getInputStream();){
                String line = Util.readLine(in);
                System.out.printf("-- %s (from %s)\n", line, this.client_sock.getRemoteSocketAddress());
                String s = String.format("srv listening on %s (host: %s)\nclient: local=%s, remote=%s\n", EchoServer.this.srv_sock.getLocalSocketAddress(), InetAddress.getLocalHost().getHostName(), this.client_sock.getLocalSocketAddress(), this.client_sock.getRemoteSocketAddress());
                output.write(s.getBytes());
                output.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

