/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.Empty;

public class AttributeMap
implements Serializable,
Cloneable {
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private static final long serialVersionUID = -7442871030874215436L;
    private HashMap namespaces;
    private String singletonNamespace;
    private HashMap singletonContent;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap copy) {
        if (copy == null) {
            return;
        }
        if (copy.singletonNamespace != null) {
            this.singletonNamespace = copy.singletonNamespace;
            this.singletonContent = (HashMap)copy.singletonContent.clone();
        }
        if (copy.namespaces == null) {
            return;
        }
        this.namespaces = (HashMap)copy.namespaces.clone();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap value = (HashMap)entry.getValue();
            entry.setValue(value.clone());
        }
    }

    public Object clone() {
        try {
            AttributeMap map = (AttributeMap)super.clone();
            if (this.singletonNamespace != null) {
                map.singletonContent = (HashMap)this.singletonContent.clone();
            }
            if (this.namespaces != null) {
                map.namespaces = (HashMap)this.namespaces.clone();
                for (Map.Entry entry : map.namespaces.entrySet()) {
                    HashMap value = (HashMap)entry.getValue();
                    entry.setValue(value.clone());
                }
            }
            return map;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Cannot happen: Clone not supported exception");
        }
    }

    public Object setAttribute(String namespace, String attribute, Object value) {
        HashMap attrs;
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonNamespace == null) {
            if (value != null) {
                this.singletonNamespace = namespace;
                this.singletonContent = new HashMap();
                this.singletonContent.put(attribute, value);
            }
            return null;
        }
        if (namespace.equals(this.singletonNamespace)) {
            if (value == null) {
                return this.singletonContent.remove(attribute);
            }
            return this.singletonContent.put(attribute, value);
        }
        if (this.namespaces == null) {
            if (value == null) {
                return null;
            }
            this.namespaces = new HashMap();
        }
        if ((attrs = (HashMap)this.namespaces.get(namespace)) == null) {
            if (value == null) {
                return null;
            }
            HashMap<String, Object> newAtts = new HashMap<String, Object>();
            newAtts.put(attribute, value);
            this.namespaces.put(namespace, newAtts);
            return null;
        }
        if (value == null) {
            Object retval = attrs.remove(attribute);
            if (attrs.isEmpty()) {
                this.namespaces.remove(namespace);
            }
            return retval;
        }
        return attrs.put(attribute, value);
    }

    public Object getAttribute(String namespace, String attribute) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonNamespace == null) {
            return null;
        }
        if (namespace.equals(this.singletonNamespace)) {
            return this.singletonContent.get(attribute);
        }
        if (this.namespaces == null) {
            return null;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return null;
        }
        return attrs.get(attribute);
    }

    public Object getFirstAttribute(String attribute) {
        Object val;
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonContent != null && (val = this.singletonContent.get(attribute)) != null) {
            return val;
        }
        if (this.namespaces == null) {
            return null;
        }
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap map = (HashMap)entry.getValue();
            Object val2 = map.get(attribute);
            if (val2 == null) continue;
            return val2;
        }
        return null;
    }

    public Map getAttributes(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (namespace.equals(this.singletonNamespace)) {
            return Collections.unmodifiableMap(this.singletonContent);
        }
        if (this.namespaces == null) {
            return Empty.MAP;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return Empty.MAP;
        }
        return Collections.unmodifiableMap(attrs);
    }

    public String[] getNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (namespace.equals(this.singletonNamespace)) {
            return this.singletonContent.keySet().toArray(new String[this.singletonContent.size()]);
        }
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return EMPTY_NAMESPACES;
        }
        return attrs.keySet().toArray(new String[attrs.size()]);
    }

    public String[] getNameSpaces() {
        if (this.namespaces == null) {
            if (this.singletonContent != null) {
                return new String[]{this.singletonNamespace};
            }
            return EMPTY_NAMESPACES;
        }
        String[] strings = this.namespaces.keySet().toArray(new String[this.namespaces.size() + 1]);
        strings[strings.length - 1] = this.singletonNamespace;
        return strings;
    }

    public void putAll(AttributeMap attributeMap) {
        boolean dontCopySingleton;
        String[] namespaces = attributeMap.getNameSpaces();
        if (namespaces.length == 0) {
            return;
        }
        if (this.singletonNamespace == null) {
            dontCopySingleton = true;
            this.singletonNamespace = attributeMap.singletonNamespace;
            this.singletonContent = (HashMap)attributeMap.singletonContent.clone();
        } else if (this.singletonNamespace.equals(attributeMap.singletonNamespace)) {
            dontCopySingleton = true;
            this.singletonContent.putAll(attributeMap.singletonContent);
        } else {
            dontCopySingleton = false;
        }
        for (int i = 0; i < namespaces.length; ++i) {
            String namespace = namespaces[i];
            Map sourceMap = attributeMap.getAttributes(namespace);
            if (dontCopySingleton && this.singletonNamespace.equals(namespace)) continue;
            HashMap targetMap = (HashMap)this.namespaces.get(namespace);
            if (targetMap == null) {
                this.namespaces.put(namespace, new HashMap(sourceMap));
                continue;
            }
            targetMap.putAll(sourceMap);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeMap that = (AttributeMap)o;
        if (this.singletonNamespace != null ? !this.singletonNamespace.equals(that.singletonNamespace) : that.singletonNamespace != null) {
            return false;
        }
        if (this.singletonContent != null ? !this.singletonContent.equals(that.singletonContent) : that.singletonContent != null) {
            return false;
        }
        return !(this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null);
    }

    public int hashCode() {
        int result = this.namespaces != null ? this.namespaces.hashCode() : 0;
        result = 31 * result + (this.singletonNamespace != null ? this.singletonNamespace.hashCode() : 0);
        result = 31 * result + (this.singletonContent != null ? this.singletonContent.hashCode() : 0);
        return result;
    }
}

