/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaPoolStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int UNUSEDSIZE;
    public static final int ALLOCATIONCOUNT;
    public static final int UNUSEDRANGECOUNT;
    public static final int BLOCKCOUNT;

    public VmaPoolStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaPoolStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaPoolStats.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedSize() {
        return VmaPoolStats.nunusedSize(this.address());
    }

    @NativeType(value="size_t")
    public long allocationCount() {
        return VmaPoolStats.nallocationCount(this.address());
    }

    @NativeType(value="size_t")
    public long unusedRangeCount() {
        return VmaPoolStats.nunusedRangeCount(this.address());
    }

    @NativeType(value="size_t")
    public long blockCount() {
        return VmaPoolStats.nblockCount(this.address());
    }

    public static VmaPoolStats malloc() {
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaPoolStats calloc() {
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaPoolStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaPoolStats create(long address) {
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)address);
    }

    @Nullable
    public static VmaPoolStats createSafe(long address) {
        return address == 0L ? null : (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaPoolStats.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaPoolStats.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaPoolStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VmaPoolStats mallocStack() {
        return VmaPoolStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaPoolStats callocStack() {
        return VmaPoolStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaPoolStats mallocStack(MemoryStack stack) {
        return VmaPoolStats.malloc(stack);
    }

    @Deprecated
    public static VmaPoolStats callocStack(MemoryStack stack) {
        return VmaPoolStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaPoolStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaPoolStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaPoolStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaPoolStats.calloc(capacity, stack);
    }

    public static VmaPoolStats malloc(MemoryStack stack) {
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaPoolStats calloc(MemoryStack stack) {
        return (VmaPoolStats)VmaPoolStats.wrap(VmaPoolStats.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaPoolStats.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nunusedSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)UNUSEDSIZE);
    }

    public static long nallocationCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATIONCOUNT));
    }

    public static long nunusedRangeCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)UNUSEDRANGECOUNT));
    }

    public static long nblockCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BLOCKCOUNT));
    }

    static {
        Struct.Layout layout = VmaPoolStats.__struct((Struct.Member[])new Struct.Member[]{VmaPoolStats.__member((int)8), VmaPoolStats.__member((int)8), VmaPoolStats.__member((int)POINTER_SIZE), VmaPoolStats.__member((int)POINTER_SIZE), VmaPoolStats.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        UNUSEDSIZE = layout.offsetof(1);
        ALLOCATIONCOUNT = layout.offsetof(2);
        UNUSEDRANGECOUNT = layout.offsetof(3);
        BLOCKCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VmaPoolStats, Buffer>
    implements NativeResource {
        private static final VmaPoolStats ELEMENT_FACTORY = VmaPoolStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaPoolStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaPoolStats.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedSize() {
            return VmaPoolStats.nunusedSize(this.address());
        }

        @NativeType(value="size_t")
        public long allocationCount() {
            return VmaPoolStats.nallocationCount(this.address());
        }

        @NativeType(value="size_t")
        public long unusedRangeCount() {
            return VmaPoolStats.nunusedRangeCount(this.address());
        }

        @NativeType(value="size_t")
        public long blockCount() {
            return VmaPoolStats.nblockCount(this.address());
        }
    }
}

