/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.agent.common.DefaultAgentForwardSupport;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.exception.SshChannelNotFoundException;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.functors.Int2IntFunction;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.DefaultX11ForwardSupport;
import org.apache.sshd.server.x11.X11ForwardSupport;

public abstract class AbstractConnectionService
extends AbstractInnerCloseable
implements ConnectionService {
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final String DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING = "ignore@sshd.apache.org";
    protected final Map<Long, Channel> channels = new ConcurrentHashMap<Long, Channel>();
    protected final AtomicLong nextChannelId = new AtomicLong(0L);
    protected final AtomicLong heartbeatCount = new AtomicLong(0L);
    private ScheduledFuture<?> heartBeat;
    private final AtomicReference<AgentForwardSupport> agentForwardHolder = new AtomicReference();
    private final AtomicReference<X11ForwardSupport> x11ForwardHolder = new AtomicReference();
    private final AtomicReference<Forwarder> forwarderHolder = new AtomicReference();
    private final AtomicBoolean allowMoreSessions = new AtomicBoolean(true);
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final Collection<PortForwardingEventListenerManager> managersHolder = new CopyOnWriteArraySet<PortForwardingEventListenerManager>();
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final PortForwardingEventListener listenerProxy;
    private final AbstractSession sessionInstance;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;

    protected AbstractConnectionService(AbstractSession session) {
        this.sessionInstance = Objects.requireNonNull(session, "No session");
        this.listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler handler) {
        this.unknownChannelReferenceHandler = handler;
    }

    @Override
    public Collection<PortForwardingEventListenerManager> getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList<PortForwardingEventListenerManager>(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        return this.managersHolder.add(Objects.requireNonNull(manager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        if (manager == null) {
            return false;
        }
        return this.managersHolder.remove(manager);
    }

    public Collection<Channel> getChannels() {
        return this.channels.values();
    }

    @Override
    public AbstractSession getSession() {
        return this.sessionInstance;
    }

    @Override
    public void start() {
        this.heartBeat = this.startHeartBeat();
    }

    protected synchronized ScheduledFuture<?> startHeartBeat() {
        this.stopHeartBeat();
        SessionHeartbeatController.HeartbeatType heartbeatType = this.getSessionHeartbeatType();
        Duration interval = this.getSessionHeartbeatInterval();
        AbstractSession session = this.getSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("startHeartbeat({}) heartbeat type={}, interval={}", new Object[]{session, heartbeatType, interval});
        }
        if (heartbeatType == null || heartbeatType == SessionHeartbeatController.HeartbeatType.NONE || GenericUtils.isNegativeOrNull(interval)) {
            return null;
        }
        FactoryManager manager = session.getFactoryManager();
        ScheduledExecutorService service = manager.getScheduledExecutorService();
        return service.scheduleAtFixedRate(this::sendHeartBeat, interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected boolean sendHeartBeat() {
        SessionHeartbeatController.HeartbeatType heartbeatType = this.getSessionHeartbeatType();
        Duration interval = this.getSessionHeartbeatInterval();
        AbstractSession session = this.getSession();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("sendHeartbeat({}) heartbeat type={}, interval={}", new Object[]{session, heartbeatType, interval});
        }
        if (heartbeatType == null || GenericUtils.isNegativeOrNull(interval) || this.heartBeat == null) {
            return false;
        }
        KexState kexState = session.getKexState();
        if (heartbeatType != SessionHeartbeatController.HeartbeatType.NONE && kexState != KexState.DONE) {
            if (traceEnabled) {
                this.log.trace("sendHeartbeat({}) heartbeat type={}, interval={} - skip due to KEX state={}", new Object[]{session, heartbeatType, interval, kexState});
            }
            return false;
        }
        try {
            switch (heartbeatType) {
                case NONE: {
                    return false;
                }
                case IGNORE: {
                    Buffer buffer = session.createBuffer((byte)2, DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING.length() + 8);
                    buffer.putString(DEFAULT_SESSION_IGNORE_HEARTBEAT_STRING);
                    IoWriteFuture future = session.writePacket(buffer);
                    future.addListener(this::futureDone);
                    return true;
                }
                case RESERVED: {
                    ReservedSessionMessagesHandler handler = Objects.requireNonNull(session.getReservedSessionMessagesHandler(), "No customized heartbeat handler registered");
                    return handler.sendReservedHeartbeat(this);
                }
            }
            throw new UnsupportedOperationException("Unsupported heartbeat type: " + (Object)((Object)heartbeatType));
        }
        catch (Throwable e) {
            session.exceptionCaught(e);
            this.warn("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", session, e.getClass().getSimpleName(), this.heartbeatCount, (Object)heartbeatType, e.getMessage(), e);
            return false;
        }
    }

    protected void futureDone(IoWriteFuture future) {
        Throwable t = future.getException();
        if (t != null) {
            AbstractSession session = this.getSession();
            session.exceptionCaught(t);
        }
    }

    protected synchronized void stopHeartBeat() {
        boolean debugEnabled = this.log.isDebugEnabled();
        AbstractSession session = this.getSession();
        if (this.heartBeat == null) {
            if (debugEnabled) {
                this.log.debug("stopHeartBeat({}) no heartbeat to stop", (Object)session);
            }
            return;
        }
        if (debugEnabled) {
            this.log.debug("stopHeartBeat({}) stopping", (Object)session);
        }
        try {
            this.heartBeat.cancel(true);
        }
        finally {
            this.heartBeat = null;
        }
        if (debugEnabled) {
            this.log.debug("stopHeartBeat({}) stopped", (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Forwarder getForwarder() {
        Forwarder forwarder;
        AbstractSession session = this.getSession();
        AtomicReference<Forwarder> atomicReference = this.forwarderHolder;
        synchronized (atomicReference) {
            forwarder = this.forwarderHolder.get();
            if (forwarder != null) {
                return forwarder;
            }
            forwarder = ValidateUtils.checkNotNull(this.createForwardingFilter(session), "No forwarder created for %s", (Object)session);
            this.forwarderHolder.set(forwarder);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getForwardingFilter({}) created instance", (Object)session);
        }
        return forwarder;
    }

    @Override
    protected void preClose() {
        this.stopHeartBeat();
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected Forwarder createForwardingFilter(Session session) {
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        ForwarderFactory factory = Objects.requireNonNull(manager.getForwarderFactory(), "No forwarder factory");
        Forwarder forwarder = factory.create(this);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        X11ForwardSupport x11Support;
        AbstractSession session = this.getSession();
        AtomicReference<X11ForwardSupport> atomicReference = this.x11ForwardHolder;
        synchronized (atomicReference) {
            x11Support = this.x11ForwardHolder.get();
            if (x11Support != null) {
                return x11Support;
            }
            x11Support = ValidateUtils.checkNotNull(this.createX11ForwardSupport(session), "No X11 forwarder created for %s", (Object)session);
            this.x11ForwardHolder.set(x11Support);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getX11ForwardSupport({}) created instance", (Object)session);
        }
        return x11Support;
    }

    protected X11ForwardSupport createX11ForwardSupport(Session session) {
        return new DefaultX11ForwardSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        AgentForwardSupport agentForward;
        AbstractSession session = this.getSession();
        AtomicReference<AgentForwardSupport> atomicReference = this.agentForwardHolder;
        synchronized (atomicReference) {
            agentForward = this.agentForwardHolder.get();
            if (agentForward != null) {
                return agentForward;
            }
            agentForward = ValidateUtils.checkNotNull(this.createAgentForwardSupport(session), "No agent forward created for %s", (Object)session);
            this.agentForwardHolder.set(agentForward);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getAgentForwardSupport({}) created instance", (Object)session);
        }
        return agentForward;
    }

    protected AgentForwardSupport createAgentForwardSupport(Session session) {
        return new DefaultAgentForwardSupport(this);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.forwarderHolder.get(), this.agentForwardHolder.get(), this.x11ForwardHolder.get()).parallel(this.toString(), this.getChannels()).build();
    }

    protected long getNextChannelId() {
        return this.nextChannelId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long registerChannel(Channel channel) throws IOException {
        AbstractSession session = this.getSession();
        int maxChannels = CoreModuleProperties.MAX_CONCURRENT_CHANNELS.getRequired(this);
        int curSize = this.channels.size();
        if (curSize > maxChannels) {
            throw new IllegalStateException("Currently active channels (" + curSize + ") at max.: " + maxChannels);
        }
        long channelId = this.getNextChannelId();
        channel.init(this, session, channelId);
        boolean registered = false;
        Map<Long, Channel> map = this.channels;
        synchronized (map) {
            if (!this.isClosing()) {
                this.channels.put(channelId, channel);
                registered = true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerChannel({})[id={}, registered={}] {}", new Object[]{this, channelId, registered, channel});
        }
        channel.handleChannelRegistrationResult(this, session, channelId, registered);
        return channelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(Channel channel) {
        Channel result;
        long channelId = channel.getChannelId();
        Map<Long, Channel> map = this.channels;
        synchronized (map) {
            result = this.channels.remove(channelId);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("unregisterChannel({}) result={}", (Object)channel, (Object)result);
        }
        if (result != null) {
            result.handleChannelUnregistration(this);
        }
    }

    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case 90: {
                this.channelOpen(buffer);
                break;
            }
            case 91: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case 92: {
                this.channelOpenFailure(buffer);
                break;
            }
            case 98: {
                this.channelRequest(buffer);
                break;
            }
            case 94: {
                this.channelData(buffer);
                break;
            }
            case 95: {
                this.channelExtendedData(buffer);
                break;
            }
            case 100: {
                this.channelFailure(buffer);
                break;
            }
            case 99: {
                this.channelSuccess(buffer);
                break;
            }
            case 93: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case 96: {
                this.channelEof(buffer);
                break;
            }
            case 97: {
                this.channelClose(buffer);
                break;
            }
            case 80: {
                this.globalRequest(buffer);
                break;
            }
            case 81: {
                this.requestSuccess(buffer);
                break;
            }
            case 82: {
                this.requestFailure(buffer);
                break;
            }
            default: {
                AbstractSession session = this.getSession();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
                }
                session.notImplemented(cmd, buffer);
            }
        }
    }

    @Override
    public boolean isAllowMoreSessions() {
        return this.allowMoreSessions.get();
    }

    @Override
    public void setAllowMoreSessions(boolean allow) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setAllowMoreSessions({}): {}", (Object)this, (Object)allow);
        }
        this.allowMoreSessions.set(allow);
    }

    public void channelOpenConfirmation(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)91, buffer);
        if (channel == null) {
            return;
        }
        long sender = buffer.getUInt();
        long rwsize = buffer.getUInt();
        long rmpsize = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelOpenConfirmation({}) SSH_MSG_CHANNEL_OPEN_CONFIRMATION sender={}, window-size={}, packet-size={}", new Object[]{channel, sender, rwsize, rmpsize});
        }
        channel.handleOpenSuccess(sender, rwsize, rmpsize, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelOpenFailure(Buffer buffer) throws IOException {
        Channel removed;
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel((byte)92, buffer);
        if (channel == null) {
            return;
        }
        long id = channel.getChannelId();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("channelOpenFailure({}) Received SSH_MSG_CHANNEL_OPEN_FAILURE", (Object)channel);
        }
        Map<Long, Channel> map = this.channels;
        synchronized (map) {
            removed = this.channels.remove(id);
        }
        if (debugEnabled) {
            this.log.debug("channelOpenFailure({}) unregistered {}", (Object)channel, (Object)removed);
        }
        channel.handleOpenFailure(buffer);
    }

    public void channelData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)94, buffer);
        if (channel == null) {
            return;
        }
        channel.handleData(buffer);
    }

    public void channelExtendedData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)95, buffer);
        if (channel == null) {
            return;
        }
        channel.handleExtendedData(buffer);
    }

    public void channelWindowAdjust(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)93, buffer);
        if (channel == null) {
            return;
        }
        channel.handleWindowAdjust(buffer);
    }

    public void channelEof(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)96, buffer);
        if (channel == null) {
            return;
        }
        channel.handleEof();
    }

    public void channelClose(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)97, buffer);
        if (channel == null) {
            return;
        }
        channel.handleClose();
    }

    public void channelRequest(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)98, buffer);
        if (channel == null) {
            return;
        }
        channel.handleRequest(buffer);
    }

    public void channelFailure(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)100, buffer);
        if (channel == null) {
            return;
        }
        channel.handleFailure();
    }

    public void channelSuccess(Buffer buffer) throws IOException {
        Channel channel = this.getChannel((byte)99, buffer);
        if (channel == null) {
            return;
        }
        channel.handleSuccess();
    }

    protected Channel getChannel(byte cmd, Buffer buffer) throws IOException {
        return this.getChannel(cmd, buffer.getUInt(), buffer);
    }

    protected Channel getChannel(byte cmd, long recipient, Buffer buffer) throws IOException {
        Channel channel = this.channels.get(recipient);
        if (channel != null) {
            return channel;
        }
        UnknownChannelReferenceHandler handler = this.resolveUnknownChannelReferenceHandler();
        if (handler == null) {
            throw new SshChannelNotFoundException(recipient, "Received " + SshConstants.getCommandMessageName(cmd) + " on unknown channel " + recipient);
        }
        channel = handler.handleUnknownChannelCommand(this, cmd, recipient, buffer);
        return channel;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler handler = this.getUnknownChannelReferenceHandler();
        if (handler != null) {
            return handler;
        }
        AbstractSession s = this.getSession();
        return s == null ? null : s.resolveUnknownChannelReferenceHandler();
    }

    protected void channelOpen(Buffer buffer) throws Exception {
        FactoryManager manager;
        String type = buffer.getString();
        final long sender = buffer.getUInt();
        long rwsize = buffer.getUInt();
        long rmpsize = buffer.getUInt();
        final boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("channelOpen({}) SSH_MSG_CHANNEL_OPEN sender={}, type={}, window-size={}, packet-size={}", new Object[]{this, sender, type, rwsize, rmpsize});
        }
        if (this.isClosing()) {
            this.sendChannelOpenFailure(buffer, sender, 2, "Server is shutting down while attempting to open channel type=" + type, "");
            return;
        }
        if (!this.isAllowMoreSessions()) {
            this.sendChannelOpenFailure(buffer, sender, 2, "additional sessions disabled", "");
            return;
        }
        final AbstractSession session = this.getSession();
        Channel channel = ChannelFactory.createChannel(session, (manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager")).getChannelFactories(), type);
        if (channel == null) {
            this.sendChannelOpenFailure(buffer, sender, 3, "Unsupported channel type: " + type, "");
            return;
        }
        final long channelId = this.registerChannel(channel);
        channel.addChannelListener(new ChannelListener(){

            @Override
            public void channelOpenSuccess(Channel channel) {
                try {
                    LocalWindow window = channel.getLocalWindow();
                    if (debugEnabled) {
                        AbstractConnectionService.this.log.debug("channelOpenSuccess({}) send SSH_MSG_CHANNEL_OPEN_CONFIRMATION recipient={}, sender={}, window-size={}, packet-size={}", new Object[]{channel, sender, channelId, window.getSize(), window.getPacketSize()});
                    }
                    Buffer buf = session.createBuffer((byte)91, 32);
                    buf.putUInt(sender);
                    buf.putUInt(channelId);
                    buf.putUInt(window.getSize());
                    buf.putUInt(window.getPacketSize());
                    session.writePacket(buf);
                }
                catch (IOException e) {
                    AbstractConnectionService.this.warn("channelOpenSuccess({}) {}: {}", AbstractConnectionService.this, e.getClass().getSimpleName(), e.getMessage(), e);
                    session.exceptionCaught(e);
                }
            }
        });
        OpenFuture openFuture = channel.open(sender, rwsize, rmpsize, buffer);
        openFuture.addListener(future -> {
            try {
                if (!future.isOpened()) {
                    int reasonCode = 0;
                    String message = "Generic error while opening channel: " + channelId;
                    Throwable exception = future.getException();
                    if (exception != null) {
                        if (exception instanceof SshChannelOpenException) {
                            reasonCode = ((SshChannelOpenException)exception).getReasonCode();
                        } else {
                            message = exception.getClass().getSimpleName() + " while opening channel: " + message;
                        }
                    } else {
                        this.log.warn("operationComplete({}) no exception on closed future={}", (Object)this, (Object)future);
                    }
                    Buffer buf = session.createBuffer((byte)92, message.length() + 64);
                    this.sendChannelOpenFailure(buf, sender, reasonCode, message, "");
                }
            }
            catch (IOException e) {
                this.warn("operationComplete({}) {}: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                session.exceptionCaught(e);
            }
        });
    }

    protected IoWriteFuture sendChannelOpenFailure(Buffer buffer, long sender, int reasonCode, String message, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendChannelOpenFailure({}) sender={}, reason={}, lang={}, message='{}'", new Object[]{this, sender, SshConstants.getOpenErrorCodeName(reasonCode), lang, message});
        }
        AbstractSession session = this.getSession();
        Buffer buf = session.createBuffer((byte)92, 64 + GenericUtils.length(message) + GenericUtils.length(lang));
        buf.putUInt(sender);
        buf.putUInt(reasonCode);
        buf.putString(message);
        buf.putString(lang);
        return session.writePacket(buf);
    }

    protected IoWriteFuture globalRequest(Buffer buffer) throws Exception {
        AbstractSession session;
        FactoryManager manager;
        List<RequestHandler<ConnectionService>> handlers;
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("globalRequest({}) received SSH_MSG_GLOBAL_REQUEST {} want-reply={}", new Object[]{this, req, wantReply});
        }
        if (GenericUtils.size(handlers = (manager = Objects.requireNonNull((session = this.getSession()).getFactoryManager(), "No factory manager")).getGlobalRequestHandlers()) > 0) {
            boolean traceEnabled = this.log.isTraceEnabled();
            for (RequestHandler requestHandler : handlers) {
                RequestHandler.Result result;
                try {
                    result = requestHandler.process(this, req, wantReply, buffer);
                }
                catch (Throwable e) {
                    this.warn("globalRequest({})[{}, want-reply={}] failed ({}) to process: {}", this, req, wantReply, e.getClass().getSimpleName(), e.getMessage(), e);
                    result = RequestHandler.Result.ReplyFailure;
                }
                if (RequestHandler.Result.Unsupported.equals((Object)result)) {
                    if (!traceEnabled) continue;
                    this.log.trace("globalRequest({}) {}#process({})[want-reply={}] : {}", new Object[]{this, requestHandler.getClass().getSimpleName(), req, wantReply, result});
                    continue;
                }
                return this.sendGlobalResponse(buffer, req, result, wantReply);
            }
        }
        return this.handleUnknownRequest(buffer, req, wantReply);
    }

    protected IoWriteFuture handleUnknownRequest(Buffer buffer, String req, boolean wantReply) throws IOException {
        this.log.warn("handleUnknownRequest({}) unknown global request: {}", (Object)this, (Object)req);
        return this.sendGlobalResponse(buffer, req, RequestHandler.Result.Unsupported, wantReply);
    }

    protected IoWriteFuture sendGlobalResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendGlobalResponse({})[{}] result={}, want-reply={}", new Object[]{this, req, result, wantReply});
        }
        if (RequestHandler.Result.Replied.equals((Object)result) || !wantReply) {
            return AbstractIoWriteFuture.fulfilled(req, Boolean.TRUE);
        }
        byte cmd = RequestHandler.Result.ReplySuccess.equals((Object)result) ? (byte)81 : 82;
        AbstractSession session = this.getSession();
        Buffer rsp = session.createBuffer(cmd, 2);
        return session.writePacket(rsp);
    }

    protected void requestSuccess(Buffer buffer) throws Exception {
        AbstractSession s = this.getSession();
        s.requestSuccess(buffer);
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        AbstractSession s = this.getSession();
        s.requestFailure(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }
}

