/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Bytes;

public class InvalidMacException
extends GeneralSecurityException {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MESSAGE = "MAC validation failed!";
    private final byte[] expected;
    private final byte[] actual;

    public InvalidMacException() {
        this(DEFAULT_MESSAGE);
    }

    public InvalidMacException(String msg) {
        super(msg);
        this.expected = Bytes.EMPTY;
        this.actual = Bytes.EMPTY;
    }

    public InvalidMacException(byte[] expected, byte[] actual) {
        super(DEFAULT_MESSAGE);
        this.expected = Arrays.copyOf(expected, expected.length);
        this.actual = Arrays.copyOf(actual, actual.length);
    }

    public final byte[] getExpected() {
        return this.expected;
    }

    public final byte[] getActual() {
        return this.actual;
    }
}

