/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.coverage;

import dotty.tools.dotc.coverage.Coverage;
import dotty.tools.dotc.coverage.Statement;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Serializer$
implements Serializable {
    private static final String CoverageFileName;
    private static final String CoverageDataFormatVersion;
    public static final Serializer$ MODULE$;

    private Serializer$() {
    }

    static {
        MODULE$ = new Serializer$();
        CoverageFileName = "scoverage.coverage";
        CoverageDataFormatVersion = "3.0";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serializer$.class);
    }

    public void serialize(Coverage coverage, String dataDir, String sourceRoot) {
        this.serialize(coverage, Paths.get(dataDir, CoverageFileName).toAbsolutePath(), Paths.get(sourceRoot, new String[0]).toAbsolutePath());
    }

    public void serialize(Coverage coverage, Path file, Path sourceRoot) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.serialize(coverage, writer, sourceRoot);
        }
    }

    public void serialize(Coverage coverage, Writer writer, Path sourceRoot) {
        this.writeHeader$1(writer);
        ((IterableOnceOps)coverage.statements().toSeq().sortBy((Function1 & Serializable)_$1 -> _$1.id(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)stmt -> this.writeStatement$1(sourceRoot, (Statement)stmt, writer));
    }

    public String escaped(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\\\");
                    continue block6;
                }
                case '\n': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\n");
                    continue block6;
                }
                case '\r': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\r");
                    continue block6;
                }
                case '\f': {
                    StringBuilder stringBuilder = builder.$plus$plus$eq("\\f");
                    continue block6;
                }
                default: {
                    char c2 = c;
                    StringBuilder stringBuilder = (StringBuilder)builder.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c2));
                    continue block6;
                }
            }
        }
        return builder.result();
    }

    private final String getRelativePath$1(Path sourceRoot$1, Path filePath) {
        Path relPath = sourceRoot$1.normalize().relativize(filePath);
        return relPath.toString();
    }

    private final void writeHeader$1(Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("# Coverage data, format version: " + CoverageDataFormatVersion + "\n                      |# Statement data:\n                      |# - id\n                      |# - source path\n                      |# - package name\n                      |# - class name\n                      |# - class type (Class, Object or Trait)\n                      |# - full class name\n                      |# - method name\n                      |# - start offset\n                      |# - end offset\n                      |# - line number\n                      |# - symbol name\n                      |# - tree name\n                      |# - is branch\n                      |# - invocations count\n                      |# - is ignored\n                      |# - description (can be multi-line)\n                      |# '\f' sign\n                      |# ------------------------------------------\n                      |")));
    }

    private final void writeStatement$1(Path sourceRoot$3, Statement stmt, Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(stmt.id() + "\n                      |" + this.escaped(this.getRelativePath$1(sourceRoot$3, stmt.location().sourcePath())) + "\n                      |" + this.escaped(stmt.location().packageName()) + "\n                      |" + this.escaped(stmt.location().className()) + "\n                      |" + stmt.location().classType() + "\n                      |" + this.escaped(stmt.location().fullClassName()) + "\n                      |" + this.escaped(stmt.location().methodName()) + "\n                      |" + stmt.start() + "\n                      |" + stmt.end() + "\n                      |" + stmt.line() + "\n                      |" + this.escaped(stmt.symbolName()) + "\n                      |" + stmt.treeName() + "\n                      |" + stmt.branch() + "\n                      |0\n                      |" + stmt.ignored() + "\n                      |" + this.escaped(stmt.desc()) + "\n                      |\f\n                      |")));
    }
}

