/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractMapView;
import scala.collection.AbstractView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.MapView$;
import scala.collection.MapViewFactory;
import scala.collection.View;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;

public interface MapView<K, V>
extends MapOps<K, V, ?, View<Tuple2<K, V>>>,
View<Tuple2<K, V>> {
    public static <K, V> View<Tuple2<K, V>> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return MapView$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <K, V> MapView<K, V> from(MapOps<K, V, IterableOps<?, Object, ?>, ?> mapOps) {
        return MapView$.MODULE$.from(mapOps);
    }

    public static <X, Y> Builder<Tuple2<X, Y>, MapView<X, Y>> newBuilder() {
        return MapView$.MODULE$.newBuilder();
    }

    public static void $init$(MapView $this) {
    }

    public static MapView view$(MapView $this) {
        return $this.view();
    }

    @Override
    default public MapView<K, V> view() {
        return this;
    }

    public static Iterable keys$(MapView $this) {
        return $this.keys();
    }

    @Override
    default public Iterable<K> keys() {
        return new Keys(this);
    }

    public static Iterable values$(MapView $this) {
        return $this.values();
    }

    @Override
    default public Iterable<V> values() {
        return new Values(this);
    }

    public static MapView filterKeys$(MapView $this, Function1 p) {
        return $this.filterKeys(p);
    }

    @Override
    default public MapView<K, V> filterKeys(Function1<K, Object> p) {
        return new FilterKeys(this, p);
    }

    public static MapView mapValues$(MapView $this, Function1 f) {
        return $this.mapValues(f);
    }

    @Override
    default public <W> MapView<K, W> mapValues(Function1<V, W> f) {
        return new MapValues(this, f);
    }

    public static MapView filter$(MapView $this, Function1 pred) {
        return $this.filter(pred);
    }

    @Override
    default public MapView<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        return new Filter<K, V>(this, false, pred);
    }

    public static MapView filterNot$(MapView $this, Function1 pred) {
        return $this.filterNot(pred);
    }

    @Override
    default public MapView<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        return new Filter<K, V>(this, true, pred);
    }

    public static Tuple2 partition$(MapView $this, Function1 p) {
        return $this.partition(p);
    }

    @Override
    default public Tuple2<MapView<K, V>, MapView<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return Tuple2$.MODULE$.apply(this.filter(p), this.filterNot(p));
    }

    public static MapView tapEach$(MapView $this, Function1 f) {
        return $this.tapEach(f);
    }

    @Override
    default public <U> MapView<K, V> tapEach(Function1<Tuple2<K, V>, U> f) {
        return new TapEach<K, V, U>(this, f);
    }

    public static MapViewFactory mapFactory$(MapView $this) {
        return $this.mapFactory();
    }

    default public MapViewFactory mapFactory() {
        return MapView$.MODULE$;
    }

    public static MapView empty$(MapView $this) {
        return $this.empty();
    }

    @Override
    default public MapView<K, V> empty() {
        return this.mapFactory().empty();
    }

    public static MapOps.WithFilter withFilter$(MapView $this, Function1 p) {
        return $this.withFilter(p);
    }

    default public MapOps.WithFilter<K, V, View, ?> withFilter(Function1<Tuple2<K, V>, Object> p) {
        return new MapOps.WithFilter(this, p);
    }

    public static String toString$(MapView $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return View.toString$(this);
    }

    public static String stringPrefix$(MapView $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "MapView";
    }

    public static class Filter<K, V>
    extends AbstractMapView<K, V> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying;
        private final boolean isFlipped;
        private final Function1<Tuple2<K, V>, Object> p;

        public Filter(MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying, boolean isFlipped, Function1<Tuple2<K, V>, Object> p) {
            this.underlying = underlying;
            this.isFlipped = isFlipped;
            this.p = p;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.underlying.iterator().filterImpl(this.p, this.isFlipped);
        }

        @Override
        public Option<V> get(K key) {
            Option<V> option = this.underlying.get(key);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object v = some.value();
                Some s = some;
                if (BoxesRunTime.unboxToBoolean(this.p.apply(Tuple2$.MODULE$.apply(key, v))) != this.isFlipped) {
                    return s;
                }
            }
            return None$.MODULE$;
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class FilterKeys<K, V>
    extends AbstractMapView<K, V> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying;
        private final Function1<K, Object> p;

        public FilterKeys(MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying, Function1<K, Object> p) {
            this.underlying = underlying;
            this.p = p;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.underlying.iterator().filter((Function1<Tuple2, Boolean> & Serializable)(A x$1) -> {
                Tuple2 tuple2 = x$1;
                Object k = tuple2._1();
                return BoxesRunTime.unboxToBoolean(this.p.apply(k));
            });
        }

        @Override
        public Option<V> get(K key) {
            if (BoxesRunTime.unboxToBoolean(this.p.apply(key))) {
                return this.underlying.get(key);
            }
            return None$.MODULE$;
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Id<K, V>
    extends AbstractMapView<K, V> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying;

        public Id(MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Option<V> get(K key) {
            return this.underlying.get(key);
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class Keys<K>
    extends AbstractView<K> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, ?, IterableOps<?, Object, ?>, ?> underlying;

        public Keys(MapOps<K, ?, IterableOps<?, Object, ?>, ?> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Iterator<K> iterator() {
            return this.underlying.keysIterator();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class MapValues<K, V, W>
    extends AbstractMapView<K, W> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying;
        private final Function1<V, W> f;

        public MapValues(MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying, Function1<V, W> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public Iterator<Tuple2<K, W>> iterator() {
            return this.underlying.iterator().map((Function1<Tuple2, Tuple2> & Serializable)(A kv) -> Tuple2$.MODULE$.apply(kv._1(), this.f.apply(kv._2())));
        }

        @Override
        public Option<W> get(K key) {
            return this.underlying.get(key).map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class TapEach<K, V, U>
    extends AbstractMapView<K, V> {
        private static final long serialVersionUID = 3L;
        private final MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying;
        private final Function1<Tuple2<K, V>, U> f;

        public TapEach(MapOps<K, V, IterableOps<?, Object, ?>, ?> underlying, Function1<Tuple2<K, V>, U> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public Option<V> get(K key) {
            Option<V> option = this.underlying.get(key);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object v = some.value();
                Some s = some;
                this.f.apply(Tuple2$.MODULE$.apply(key, v));
                return s;
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.underlying.iterator().tapEach(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class Values<V>
    extends AbstractView<V> {
        private static final long serialVersionUID = 3L;
        private final MapOps<?, V, IterableOps<?, Object, ?>, ?> underlying;

        public Values(MapOps<?, V, IterableOps<?, Object, ?>, ?> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Iterator<V> iterator() {
            return this.underlying.valuesIterator();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }
}

