/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.BasePositionHandler;
import org.traccar.handler.OutdatedHandler;
import org.traccar.model.Position;

@Singleton
public class TimeHandler
extends BasePositionHandler {
    private static final long ROLLOVER_CYCLE = 1024L * Duration.ofDays(7L).toMillis();
    private static final long ROLLOVER_THRESHOLD = ROLLOVER_CYCLE - Duration.ofDays(90L).toMillis();
    private final String overrideType;
    private final Set<String> overrideProtocols;

    @Inject
    public TimeHandler(Config config) {
        this.overrideType = config.getString(Keys.TIME_OVERRIDE);
        String protocolList = config.getString(Keys.TIME_PROTOCOLS);
        this.overrideProtocols = protocolList != null ? new HashSet<String>(Arrays.asList(protocolList.split("[, ]"))) : null;
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        this.handleRollover(position);
        this.handleOverride(position);
        callback.processed(false);
    }

    private void handleRollover(Position position) {
        long currentTime = System.currentTimeMillis();
        position.setDeviceTime(TimeHandler.adjustRollover(currentTime, position.getDeviceTime()));
        position.setFixTime(TimeHandler.adjustRollover(currentTime, position.getFixTime()));
    }

    public static Date adjustRollover(long currentTime, Date time) {
        long positionTime;
        for (positionTime = time.getTime(); positionTime > OutdatedHandler.GPS_EPOCH && currentTime - positionTime > ROLLOVER_THRESHOLD; positionTime += ROLLOVER_CYCLE) {
        }
        return positionTime == time.getTime() ? time : new Date(positionTime);
    }

    private void handleOverride(Position position) {
        if (this.overrideType == null) {
            return;
        }
        if (this.overrideProtocols != null && !this.overrideProtocols.contains(position.getProtocol())) {
            return;
        }
        switch (this.overrideType) {
            case "serverTime": {
                position.setDeviceTime(position.getServerTime());
                position.setFixTime(position.getServerTime());
                break;
            }
            default: {
                position.setFixTime(position.getDeviceTime());
            }
        }
    }
}

