/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import nu.validator.messages.MessageTextHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.SAXException;

public final class XhtmlMessageTextHandler
implements MessageTextHandler {
    private final AttributesImpl attrs = new AttributesImpl();
    private static final AttributesImpl LINE_BREAK_ATTRS = new AttributesImpl();
    private static final char[] NEWLINE_SUBSTITUTE = new char[]{'\u21a9'};
    private final XhtmlSaxEmitter emitter;
    private static final Map<String, String[]> MAGIC_LINKS;

    public XhtmlMessageTextHandler(XhtmlSaxEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch);
        TreeMap<Integer, String> linkText = new TreeMap<Integer, String>();
        for (Map.Entry<String, String[]> entry : MAGIC_LINKS.entrySet()) {
            int index = str.indexOf(entry.getKey());
            if (index == -1) continue;
            linkText.put(index, entry.getKey());
        }
        if (!linkText.isEmpty()) {
            int position = start;
            for (Map.Entry entry : linkText.entrySet()) {
                int linkstart = (Integer)entry.getKey();
                String text = (String)entry.getValue();
                this.emitter.characters(ch, position, linkstart - position - start);
                this.startLink(MAGIC_LINKS.get(text)[0], MAGIC_LINKS.get(text)[1]);
                this.emitter.characters(ch, linkstart, text.length());
                this.endLink();
                position = linkstart + text.length();
            }
            if (position < length) {
                this.characterz(ch, position, length - position);
            }
        } else {
            this.characterz(ch, start, length);
        }
    }

    private void characterz(char[] ch, int start, int length) throws SAXException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char c = ch[i];
            switch (c) {
                case '\n': 
                case '\r': {
                    if (start < i) {
                        this.emitter.characters(ch, start, i - start);
                    }
                    start = i + 1;
                    this.emitter.startElement("span", LINE_BREAK_ATTRS);
                    this.emitter.characters(NEWLINE_SUBSTITUTE);
                    this.emitter.endElement("span");
                }
            }
        }
        if (start < end) {
            this.emitter.characters(ch, start, end - start);
        }
    }

    @Override
    public void endCode() throws SAXException {
        this.emitter.endElement("code");
    }

    @Override
    public void endLink() throws SAXException {
        this.emitter.endElement("a");
    }

    @Override
    public void startCode() throws SAXException {
        this.emitter.startElement("code");
    }

    @Override
    public void startLink(String href, String title) throws SAXException {
        assert (href != null);
        this.attrs.clear();
        this.attrs.addAttribute("href", href);
        if (title != null) {
            this.attrs.addAttribute("title", title);
        }
        this.emitter.startElement("a", this.attrs);
    }

    static {
        LINE_BREAK_ATTRS.addAttribute("class", "lf");
        LINE_BREAK_ATTRS.addAttribute("title", "Line break");
        MAGIC_LINKS = new HashMap<String, String[]>();
        MAGIC_LINKS.put("Use CSS instead", new String[]{"http://wiki.whatwg.org/wiki/Presentational_elements_and_attributes", "About using CSS instead of presentational elements and attributes."});
        MAGIC_LINKS.put("register the names as meta extensions", new String[]{"http://wiki.whatwg.org/wiki/MetaExtensions", "About registering names as meta extensions."});
        MAGIC_LINKS.put("guidance on providing text alternatives for images", new String[]{"https://www.w3.org/WAI/tutorials/images/", "About providing text alternatives for images."});
    }
}

