/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGlseg
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGlseg(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
    }

    public PGlseg(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGlseg(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGlseg() {
        this.setType("lseg");
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGlseg) {
            PGlseg p = (PGlseg)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    public Object clone() {
        return new PGlseg((PGpoint)this.point[0].clone(), (PGpoint)this.point[1].clone());
    }

    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

