/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefiles;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.deletefiles.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDeleteFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean argFromPrevious;
    public boolean includeSubfolders;
    public String[] arguments;
    public String[] filemasks;

    public JobEntryDeleteFiles(String n) {
        super(n, "");
        this.argFromPrevious = false;
        this.arguments = null;
        this.includeSubfolders = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.DELETE_FILES);
    }

    public JobEntryDeleteFiles() {
        this("");
    }

    public JobEntryDeleteFiles(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryDeleteFiles je = (JobEntryDeleteFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.filemasks = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryDeleteFiles.UnableToLoadFromXml"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.filemasks = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.filemasks[a] = rep.getJobEntryAttributeString(id_jobentry, a, "filemask");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFiles.UnableToLoadFromRepo", String.valueOf(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_subfolders", this.includeSubfolders);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "filemask", this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFiles.UnableToSaveToRepo", String.valueOf(id_job)), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int NrErrFiles = 0;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.argFromPrevious && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.FoundPreviousRows", String.valueOf(rows != null ? rows.size() : 0)), new Object[0]);
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String args_previous = resultRow.getString(0, null);
                String fmasks_previous = resultRow.getString(1, null);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.ProcessingRow", args_previous, fmasks_previous), new Object[0]);
                }
                if (this.ProcessFile(args_previous, fmasks_previous, parentJob)) continue;
                ++NrErrFiles;
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !parentJob.isStopped(); ++i) {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.ProcessingArg", this.arguments[i], this.filemasks[i]), new Object[0]);
                }
                if (this.ProcessFile(this.arguments[i], this.filemasks[i], parentJob)) continue;
                ++NrErrFiles;
            }
        }
        if (NrErrFiles == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)NrErrFiles);
            result.setResult(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ProcessFile(String filename, String wildcard, Job parentJob) {
        String realFilefoldername;
        FileObject filefolder;
        boolean rcode;
        LogWriter log;
        block18: {
            log = LogWriter.getInstance();
            rcode = false;
            filefolder = null;
            realFilefoldername = this.environmentSubstitute(filename);
            String realwildcard = this.environmentSubstitute(wildcard);
            filefolder = KettleVFS.getFileObject((String)realFilefoldername);
            System.gc();
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.ProcessingFolder", realFilefoldername), new Object[0]);
                    }
                    int Nr = filefolder.delete((FileSelector)new TextFileSelector(filefolder.toString(), realwildcard, parentJob));
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.TotalDeleted", String.valueOf(Nr)), new Object[0]);
                    }
                    rcode = true;
                } else {
                    boolean deleted;
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.ProcessingFile", realFilefoldername), new Object[0]);
                    }
                    if (!(deleted = filefolder.delete())) {
                        log.logError(this.toString(), Messages.getString("JobEntryDeleteFiles.CouldNotDeleteFile", realFilefoldername), new Object[0]);
                    } else {
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), Messages.getString("JobEntryDeleteFiles.FileDeleted", filename), new Object[0]);
                        }
                        rcode = true;
                    }
                }
                break block18;
            }
            if (log.isBasic()) {
                log.logBasic(this.toString(), Messages.getString("JobEntryDeleteFiles.FileAlreadyDeleted", realFilefoldername), new Object[0]);
            }
            rcode = true;
        }
        Object var11_12 = null;
        if (filefolder == null) return rcode;
        try {
            filefolder.close();
            return rcode;
        }
        catch (IOException ex) {}
        return rcode;
        {
            catch (IOException e) {
                log.logError(this.toString(), Messages.getString("JobEntryDeleteFiles.CouldNotProcess", realFilefoldername, e.getMessage()), new Object[0]);
                Object var11_13 = null;
                if (filefolder == null) return rcode;
                try {
                    filefolder.close();
                    return rcode;
                }
                catch (IOException ex) {}
                return rcode;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (filefolder == null) throw throwable;
            try {
                filefolder.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    private class TextFileSelector
    implements FileSelector {
        LogWriter log = LogWriter.getInstance();
        String file_wildcard = null;
        String source_folder = null;
        Job parentjob;

        public TextFileSelector(String sourcefolderin, String filewildcard, Job parentJob) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.source_folder = sourcefolderin;
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.file_wildcard = filewildcard;
            }
            this.parentjob = parentJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean includeFile(FileSelectInfo info) {
            Object file_name;
            boolean returncode;
            block12: {
                returncode = false;
                file_name = null;
                if (info.getFile().toString().equals(this.source_folder) || this.parentjob.isStopped()) break block12;
                String short_filename = info.getFile().getName().getBaseName();
                if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                    if (JobEntryDeleteFiles.this.includeSubfolders && info.getFile().getType() == FileType.FILE && JobEntryDeleteFiles.this.GetFileWildcard(short_filename, this.file_wildcard)) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.DeletingFile", info.getFile().toString()), new Object[0]);
                        }
                        returncode = true;
                    }
                    break block12;
                }
                if (info.getFile().getType() != FileType.FILE || !JobEntryDeleteFiles.this.GetFileWildcard(short_filename, this.file_wildcard)) break block12;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFiles.DeletingFile", info.getFile().toString()), new Object[0]);
                }
                returncode = true;
            }
            Object var6_6 = null;
            if (file_name == null) return returncode;
            try {
                file_name.close();
                return returncode;
            }
            catch (IOException ex) {}
            return returncode;
            {
                catch (Exception e) {
                    this.log.logError(Messages.getString("JobDeleteFiles.Error.Exception.DeleteProcessError"), Messages.getString("JobDeleteFiles.Error.Exception.DeleteProcess", info.getFile().toString(), e.getMessage()), new Object[0]);
                    returncode = false;
                    Object var6_7 = null;
                    if (file_name == null) return returncode;
                    try {
                        file_name.close();
                        return returncode;
                    }
                    catch (IOException ex) {}
                    return returncode;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (file_name == null) throw throwable;
                try {
                    file_name.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

