/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.swingui.querypen.EditStyledTextListener;
import ca.sqlpower.swingui.querypen.QueryPen;
import ca.sqlpower.swingui.querypen.event.ExtendedStyledTextEventHandler;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class EditablePStyledText
extends PStyledText {
    private static final Logger logger = Logger.getLogger(EditablePStyledText.class);
    private final JEditorPane editorPane;
    private final SimpleAttributeSet attributeSet;
    private final ExtendedStyledTextEventHandler styledTextEventHandler;
    private FocusListener editorFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            EditablePStyledText.this.styledTextEventHandler.stopEditing();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    };
    private DefaultStyledDocument doc;
    private List<EditStyledTextListener> editingListeners;
    private boolean showHoverBorder;
    private EditStyledTextListener emptyListener = new EditStyledTextListener(){

        @Override
        public void editingStopping() {
            EditablePStyledText.this.fillWithSpaces();
        }

        @Override
        public void editingStarting() {
            EditablePStyledText.this.editorPane.setText(EditablePStyledText.this.editorPane.getText().trim());
        }
    };
    protected final int minCharCountSize;
    private final PCanvas canvas;
    private final PropertyChangeListener cameraViewChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.debug((Object)("Property changed for scroll, type: " + evt.getPropertyName()));
            Insets pInsets = EditablePStyledText.this.getInsets();
            Point2D.Double nodePt = new Point2D.Double(EditablePStyledText.this.getX() + (double)pInsets.left, EditablePStyledText.this.getY() + (double)pInsets.top);
            EditablePStyledText.this.localToGlobal(nodePt);
            EditablePStyledText.this.canvas.getCamera().viewToLocal((Point2D)nodePt);
            Insets bInsets = EditablePStyledText.this.editorPane.getBorder().getBorderInsets(EditablePStyledText.this.editorPane);
            EditablePStyledText.this.editorPane.setLocation((int)((Point2D)nodePt).getX() - bInsets.left, (int)((Point2D)nodePt).getY() - bInsets.top);
        }
    };
    protected final String startingText;

    public EditablePStyledText(QueryPen queryPen, PCanvas canvas) {
        this("", queryPen, canvas);
    }

    public EditablePStyledText(String startingText, QueryPen queryPen, PCanvas canvas) {
        this(startingText, queryPen, canvas, 0);
    }

    public EditablePStyledText(String startingText, QueryPen queryPen, PCanvas canvas, int minCharCountSize) {
        this.startingText = startingText;
        this.minCharCountSize = minCharCountSize;
        this.canvas = canvas;
        this.editorPane = new JEditorPane();
        this.editingListeners = new ArrayList<EditStyledTextListener>();
        this.doc = new DefaultStyledDocument();
        this.attributeSet = new SimpleAttributeSet();
        this.attributeSet.addAttribute(StyleConstants.FontFamily, UIManager.getFont("List.font").getFamily());
        this.editorPane.setDocument(this.doc);
        this.editorPane.setBorder(new LineBorder(this.editorPane.getForeground()));
        this.editorPane.setText(startingText);
        this.doc.setParagraphAttributes(0, this.editorPane.getText().length(), this.attributeSet, false);
        this.setDocument(this.editorPane.getDocument());
        this.addEditStyledTextListener(this.emptyListener);
        canvas.getCamera().addPropertyChangeListener("viewTransform", this.cameraViewChangeListener);
        this.styledTextEventHandler = new ExtendedStyledTextEventHandler(queryPen, canvas, this.editorPane){

            public void startEditing(PInputEvent event, PStyledText text) {
                for (EditStyledTextListener l : EditablePStyledText.this.editingListeners) {
                    l.editingStarting();
                }
                super.startEditing(event, text);
            }

            public void stopEditing() {
                EditablePStyledText.this.editorPane.setText(EditablePStyledText.this.editorPane.getText().replaceAll("\n", "").trim());
                EditablePStyledText.this.fillWithSpaces();
                EditablePStyledText.this.syncWithDocument();
                for (EditStyledTextListener l : EditablePStyledText.this.editingListeners) {
                    l.editingStopping();
                }
                super.stopEditing();
                logger.debug((Object)"Editing stopped.");
            }
        };
        this.addInputEventListener((PInputEventListener)this.styledTextEventHandler);
        this.editorPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EditablePStyledText.this.styledTextEventHandler.stopEditing();
                }
            }
        });
        this.editorPane.addFocusListener(this.editorFocusListener);
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent event) {
                EditablePStyledText.this.showHoverBorder = true;
                EditablePStyledText.this.repaint();
            }

            public void mouseExited(PInputEvent event) {
                EditablePStyledText.this.showHoverBorder = false;
                EditablePStyledText.this.repaint();
            }
        });
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        Graphics2D g = paintContext.getGraphics();
        Paint oldPaint = g.getPaint();
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(1.0f));
        g.setPaint(Color.GRAY);
        if (this.showHoverBorder) {
            g.drawRect((int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        }
        g.setStroke(oldStroke);
        g.setPaint(oldPaint);
    }

    protected FocusListener getEditorFocusListener() {
        return this.editorFocusListener;
    }

    protected ExtendedStyledTextEventHandler getStyledTextEventHandler() {
        return this.styledTextEventHandler;
    }

    public void addEditStyledTextListener(EditStyledTextListener l) {
        this.editingListeners.add(l);
    }

    public void removeEditStyledTextListener(EditStyledTextListener l) {
        this.editingListeners.add(l);
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    private void fillWithSpaces() {
        if (this.editorPane.getText() == null || this.editorPane.getText().trim().equals("")) {
            this.editorPane.setText(this.startingText);
            this.syncWithDocument();
        } else if (this.editorPane.getText().length() < this.minCharCountSize) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.minCharCountSize - this.editorPane.getText().length(); ++i) {
                sb.append(" ");
            }
            this.editorPane.setText(this.editorPane.getText() + sb.toString());
            this.syncWithDocument();
        }
    }
}

