/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.common.deployment;

import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.internal.PickFirstLoadBalancerProvider;
import io.grpc.netty.NettyChannelProvider;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.grpc.common.deployment.GrpcDotNames;
import java.util.Collection;
import org.jboss.jandex.ClassInfo;

public class GrpcCommonProcessor {
    @BuildStep
    public void configureNativeExecutable(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Collection messages = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.GENERATED_MESSAGE_V3);
        for (Object message : messages) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{message.name().toString()}).methods().fields().build());
        }
        Collection enums = combinedIndex.getIndex().getAllKnownImplementations(GrpcDotNames.PROTOCOL_MESSAGE_ENUM);
        for (Object en : enums) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{en.name().toString()}).methods().fields().build());
        }
        Collection builders = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.MESSAGE_BUILDER);
        for (Object builder : builders) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{builder.name().toString()}).methods().fields().build());
        }
        Collection lbs = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.LOAD_BALANCER_PROVIDER);
        for (ClassInfo lb : lbs) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{lb.name().toString()}).methods().build());
        }
        Collection nrs = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.NAME_RESOLVER_PROVIDER);
        for (ClassInfo nr : nrs) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{nr.name().toString()}).methods().build());
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DnsNameResolverProvider.class, PickFirstLoadBalancerProvider.class, NettyChannelProvider.class}).methods().reason(this.getClass().getName() + " built-in provider").build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider"}).reason(this.getClass().getName() + " built-in provider").methods().build());
    }

    @BuildStep
    NativeImageConfigBuildItem nativeImageConfiguration() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.grpc.netty.Utils$ByteBufAllocatorPreferDirectHolder").addRuntimeInitializedClass("io.grpc.netty.Utils$ByteBufAllocatorPreferHeapHolder").addRuntimeInitializedClass("io.grpc.netty.Utils").addRuntimeInitializedClass("io.grpc.netty.NettyServerBuilder").addRuntimeInitializedClass("io.grpc.netty.NettyChannelBuilder").addRuntimeInitializedClass("io.grpc.internal.RetriableStream").addRuntimeReinitializedClass("com.google.protobuf.UnsafeUtil");
        return builder.build();
    }
}

