/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater.authsession;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.SessionEntityUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RootAuthenticationSessionUpdater
extends BaseUpdater<String, RootAuthenticationSessionEntity>
implements RootAuthenticationSessionModel {
    private static final Comparator<Map.Entry<String, AuthenticationSessionEntity>> TIMESTAMP_COMPARATOR = Comparator.comparingInt(e -> ((AuthenticationSessionEntity)e.getValue()).getTimestamp());
    private final List<Consumer<RootAuthenticationSessionEntity>> changes;
    private RealmModel realm;
    private KeycloakSession session;
    private int authSessionsLimit;

    private RootAuthenticationSessionUpdater(String key, RootAuthenticationSessionEntity entity, long version, BaseUpdater.UpdaterState initialState) {
        super(key, entity, version, initialState);
        if (entity == null) {
            assert (initialState == BaseUpdater.UpdaterState.DELETED);
            this.changes = List.of();
            return;
        }
        this.changes = new ArrayList<Consumer<RootAuthenticationSessionEntity>>(4);
    }

    public synchronized void initialize(KeycloakSession session, RealmModel realm, int authSessionsLimit) {
        this.session = session;
        this.realm = realm;
        this.authSessionsLimit = authSessionsLimit;
    }

    public synchronized boolean isInitialized() {
        return this.session != null;
    }

    @Override
    protected boolean isUnchanged() {
        return this.changes.isEmpty();
    }

    public static RootAuthenticationSessionUpdater create(String key, RootAuthenticationSessionEntity entity) {
        return new RootAuthenticationSessionUpdater(key, Objects.requireNonNull(entity), -1L, BaseUpdater.UpdaterState.CREATED);
    }

    public static RootAuthenticationSessionUpdater wrap(String key, RootAuthenticationSessionEntity value, long version) {
        return new RootAuthenticationSessionUpdater(key, Objects.requireNonNull(value), version, BaseUpdater.UpdaterState.READ);
    }

    public static RootAuthenticationSessionUpdater delete(String key) {
        return new RootAuthenticationSessionUpdater(key, null, -1L, BaseUpdater.UpdaterState.DELETED);
    }

    @Override
    public Expiration computeExpiration() {
        return new Expiration(SessionTimeouts.getAuthSessionMaxIdleMS(this.realm, null, (RootAuthenticationSessionEntity)this.getValue()), SessionTimeouts.getAuthSessionLifespanMS(this.realm, null, (RootAuthenticationSessionEntity)this.getValue()));
    }

    @Override
    public RootAuthenticationSessionEntity apply(String ignored, RootAuthenticationSessionEntity cachedEntity) {
        assert (!this.isDeleted());
        assert (!this.isReadOnly());
        if (cachedEntity == null) {
            return null;
        }
        this.changes.forEach(c -> c.accept(cachedEntity));
        return cachedEntity.getAuthenticationSessions().isEmpty() ? null : cachedEntity;
    }

    public String getId() {
        return (String)this.getKey();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return ((RootAuthenticationSessionEntity)this.getValue()).getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.addAndApplyChange(entity -> entity.setTimestamp(timestamp));
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        HashMap<String, AuthenticationSessionModel> result = new HashMap<String, AuthenticationSessionModel>();
        for (Map.Entry<String, AuthenticationSessionEntity> entry : ((RootAuthenticationSessionEntity)this.getValue()).getAuthenticationSessions().entrySet()) {
            String tabId = entry.getKey();
            result.put(tabId, new AuthenticationSessionAdapter(this.session, this, new AuthenticationSessionUpdater(this, tabId, entry.getValue()), tabId));
        }
        return result;
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            this.session.getContext().setAuthenticationSession(authSession);
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        Objects.requireNonNull(client, "client");
        AuthenticationSessionEntity authSessionEntity = new AuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        String newTabId = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
        int timestamp = Time.currentTime();
        this.addAndApplyChange(entity -> {
            Map<String, AuthenticationSessionEntity> authenticationSessions = entity.getAuthenticationSessions();
            if (authenticationSessions.size() >= this.authSessionsLimit && !authenticationSessions.containsKey(newTabId)) {
                authenticationSessions.entrySet().stream().min(TIMESTAMP_COMPARATOR).map(Map.Entry::getKey).ifPresent(authenticationSessions::remove);
            }
            authSessionEntity.setTimestamp(timestamp);
            authenticationSessions.put(newTabId, authSessionEntity);
            entity.setTimestamp(timestamp);
        });
        AuthenticationSessionAdapter authSession = new AuthenticationSessionAdapter(this.session, this, new AuthenticationSessionUpdater(this, newTabId, authSessionEntity), newTabId);
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)authSession);
        return authSession;
    }

    public void removeAuthenticationSessionByTabId(String tabId) {
        if (((RootAuthenticationSessionEntity)this.getValue()).getAuthenticationSessions().remove(tabId) != null) {
            if (((RootAuthenticationSessionEntity)this.getValue()).getAuthenticationSessions().isEmpty()) {
                this.markDeleted();
            } else {
                int currentTime = Time.currentTime();
                this.addAndApplyChange(entity -> {
                    entity.getAuthenticationSessions().remove(tabId);
                    entity.setTimestamp(currentTime);
                });
            }
        }
    }

    public void restartSession(RealmModel realm) {
        this.addAndApplyChange(entity -> {
            entity.getAuthenticationSessions().clear();
            entity.setTimestamp(Time.currentTime());
        });
    }

    private void addAndApplyChange(Consumer<RootAuthenticationSessionEntity> change) {
        this.changes.add(change);
        change.accept((RootAuthenticationSessionEntity)this.getValue());
    }

    private record AuthenticationSessionUpdater(RootAuthenticationSessionUpdater updater, String tabId, AuthenticationSessionEntity authenticationSession) implements SessionEntityUpdater<AuthenticationSessionEntity>
    {
        @Override
        public AuthenticationSessionEntity getEntity() {
            return this.authenticationSession;
        }

        @Override
        public void onEntityUpdated() {
            this.updater.addAndApplyChange(entity -> entity.getAuthenticationSessions().put(this.tabId, this.authenticationSession));
        }

        @Override
        public void onEntityRemoved() {
        }
    }
}

