/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import org.objectweb.asm.MethodVisitor;

public class PanacheFieldAccessMethodVisitor
extends MethodVisitor {
    private final String methodName;
    private final String methodOwnerClassName;
    private final String methodDescriptor;
    private final MetamodelInfo modelInfo;

    public PanacheFieldAccessMethodVisitor(MethodVisitor methodVisitor, String methodOwner, String methodName, String methodDescriptor, MetamodelInfo modelInfo) {
        super(589824, methodVisitor);
        this.methodOwnerClassName = methodOwner.replace('/', '.');
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.modelInfo = modelInfo;
    }

    public void visitFieldInsn(int opcode, String fieldOwner, String fieldName, String descriptor) {
        String methodDescriptor;
        String librarySpecificMethodName;
        String javaBeanMethodName;
        String fieldOwnerClassName = fieldOwner.replace('/', '.');
        if (opcode != 180 && opcode != 181 || this.methodName.equals("<init>") && this.targetIsInHierarchy(this.methodOwnerClassName, fieldOwnerClassName)) {
            super.visitFieldInsn(opcode, fieldOwner, fieldName, descriptor);
            return;
        }
        EntityModel declaringEntityModel = this.getDeclaringEntityModel(fieldOwnerClassName, fieldName);
        if (declaringEntityModel == null) {
            super.visitFieldInsn(opcode, fieldOwner, fieldName, descriptor);
            return;
        }
        EntityField entityField = declaringEntityModel.fields.get(fieldName);
        if (opcode == 180) {
            javaBeanMethodName = entityField.getGetterName();
            librarySpecificMethodName = entityField.librarySpecificGetterName;
            methodDescriptor = "()" + descriptor;
        } else {
            javaBeanMethodName = entityField.getSetterName();
            librarySpecificMethodName = entityField.librarySpecificSetterName;
            methodDescriptor = "(" + descriptor + ")V";
        }
        boolean useJavaBeanAccessor = EntityField.Visibility.PUBLIC.equals((Object)entityField.visibility);
        if (fieldOwnerClassName.equals(this.methodOwnerClassName) && javaBeanMethodName.equals(this.methodName) && methodDescriptor.equals(this.methodDescriptor)) {
            if (declaringEntityModel.name.equals(this.methodOwnerClassName)) {
                super.visitFieldInsn(opcode, fieldOwner, fieldName, descriptor);
                return;
            }
            useJavaBeanAccessor = false;
        }
        if (!useJavaBeanAccessor && librarySpecificMethodName == null) {
            super.visitFieldInsn(opcode, fieldOwner, fieldName, descriptor);
            return;
        }
        String methodName = useJavaBeanAccessor ? javaBeanMethodName : librarySpecificMethodName;
        super.visitMethodInsn(182, fieldOwner, methodName, methodDescriptor, false);
    }

    private boolean targetIsInHierarchy(String currentClass, String targetClass) {
        if (currentClass.equals(targetClass)) {
            return true;
        }
        EntityModel entityModel = this.modelInfo.getEntityModel(currentClass);
        if (entityModel == null) {
            return false;
        }
        if (entityModel.superClassName != null) {
            return this.targetIsInHierarchy(entityModel.superClassName, targetClass);
        }
        return false;
    }

    EntityModel getDeclaringEntityModel(String encounteredClassName, String fieldName) {
        EntityModel entityModel = this.modelInfo.getEntityModel(encounteredClassName);
        if (entityModel == null) {
            return null;
        }
        EntityField field = entityModel.fields.get(fieldName);
        if (field != null) {
            return entityModel;
        }
        if (entityModel.superClassName != null) {
            return this.getDeclaringEntityModel(entityModel.superClassName, fieldName);
        }
        return null;
    }
}

