/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.attribute.ServletRequestURLAttribute;

public class ServletRequestLineAttribute
implements ExchangeAttribute {
    public static final String REQUEST_LINE_SHORT = "%r";
    public static final String REQUEST_LINE = "%{REQUEST_LINE}";
    public static final ExchangeAttribute INSTANCE = new ServletRequestLineAttribute();

    private ServletRequestLineAttribute() {
    }

    public String readAttribute(HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder().append(exchange.getRequestMethod()).append(' ').append(ServletRequestURLAttribute.INSTANCE.readAttribute(exchange));
        if (!exchange.getQueryString().isEmpty()) {
            sb.append('?');
            sb.append(exchange.getQueryString());
        }
        sb.append(' ').append(exchange.getProtocol());
        return sb.toString();
    }

    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request line", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        public String name() {
            return "Request line";
        }

        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestLineAttribute.REQUEST_LINE) || token.equals(ServletRequestLineAttribute.REQUEST_LINE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        public int priority() {
            return 1;
        }
    }
}

