/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.monitors;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;

public class SystemMonitor {
    public static Report detect() {
        return new Report(ManagementFactory.getOperatingSystemMXBean());
    }

    public static class Report {
        private static final String OS_NAME = "os.name";
        private static final String OS_VERSION = "os.version";
        private static final String OS_ARCH = "os.arch";
        private static final String SYSTEM_AVAILABLE_PROCESSORS = "system.available_processors";
        private static final String SYSTEM_LOAD_AVERAGE = "system.load_average";
        private Map<String, Object> map = new HashMap<String, Object>();

        Report(OperatingSystemMXBean osBean) {
            this.map.put(OS_NAME, osBean.getName());
            this.map.put(OS_VERSION, osBean.getVersion());
            this.map.put(OS_ARCH, osBean.getArch());
            this.map.put(SYSTEM_AVAILABLE_PROCESSORS, osBean.getAvailableProcessors());
            this.map.put(SYSTEM_LOAD_AVERAGE, osBean.getSystemLoadAverage());
        }

        public Map<String, Object> toMap() {
            return this.map;
        }
    }
}

