/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DayTimeDurationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Adjust
extends SystemFunctionCall
implements Callable {
    @Override
    public CalendarValue evaluateItem(XPathContext context) throws XPathException {
        CalendarValue in = (CalendarValue)this.argument[0].evaluateItem(context);
        if (in == null) {
            return null;
        }
        int nargs = this.argument.length;
        if (nargs == 1) {
            int tz = context.getImplicitTimezone();
            if (tz == Integer.MIN_VALUE) {
                throw new NoDynamicContextException("implicit timezone");
            }
            return in.adjustTimezone(context.getImplicitTimezone());
        }
        AtomicValue av2 = (AtomicValue)this.argument[1].evaluateItem(context);
        if (av2 == null) {
            return in.removeTimezone();
        }
        return this.adjustToExplicitTimezone(in, (DayTimeDurationValue)av2, context);
    }

    private CalendarValue adjustToExplicitTimezone(CalendarValue in, DayTimeDurationValue tz, XPathContext context) throws XPathException {
        long microseconds = tz.getLengthInMicroseconds();
        if (microseconds % 60000000L != 0L) {
            XPathException err = new XPathException("Timezone is not an integral number of minutes", "FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        int tzminutes = (int)(microseconds / 60000000L);
        if (Math.abs(tzminutes) > 840) {
            XPathException err = new XPathException("Timezone out of range (-14:00 to +14:00)", "FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        return in.adjustTimezone(tzminutes);
    }

    @Override
    public ZeroOrOne<CalendarValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        CalendarValue in = (CalendarValue)arguments[0].head();
        if (in == null) {
            return ZeroOrOne.empty();
        }
        if (arguments.length == 1) {
            return new ZeroOrOne<CalendarValue>(in.adjustTimezone(context.getImplicitTimezone()));
        }
        DayTimeDurationValue tz = (DayTimeDurationValue)arguments[1].head();
        if (tz == null) {
            return new ZeroOrOne<CalendarValue>(in.removeTimezone());
        }
        return new ZeroOrOne<CalendarValue>(this.adjustToExplicitTimezone(in, tz, context));
    }
}

