/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.secret.SecretIdentifier;
import org.logstash.secret.SecretVariable;
import org.logstash.secret.store.SecretStore;

public class ConfigVariableExpander
implements AutoCloseable {
    public static final Pattern KEY_PATTERN = Pattern.compile("[a-zA-Z_.][a-zA-Z0-9_.]*");
    public static final String KEY_PATTERN_DESCRIPTION = "Key names are limited to ASCII letters (`a`-`z`, `A`-`Z`), numbers (`0`-`9`), underscores (`_`), and dots (`.`); they must be at least one character long and cannot begin with a number";
    private static final String SUBSTITUTION_PLACEHOLDER_REGEX = "\\$\\{(?<name>" + String.valueOf(KEY_PATTERN) + ")(:(?<default>[^}]*))?}";
    private static final Pattern substitutionPattern = Pattern.compile(SUBSTITUTION_PLACEHOLDER_REGEX);
    private final SecretStore secretStore;
    private final EnvironmentVariableProvider envVarProvider;

    public static ConfigVariableExpander withoutSecret(EnvironmentVariableProvider envVarProvider) {
        return new ConfigVariableExpander(null, envVarProvider);
    }

    public ConfigVariableExpander(SecretStore secretStore, EnvironmentVariableProvider envVarProvider) {
        this.secretStore = secretStore;
        this.envVarProvider = envVarProvider;
    }

    public Object expand(Object value, boolean keepSecrets) {
        String evValue;
        byte[] ssValue;
        if (!(value instanceof String)) {
            return value;
        }
        String variable = (String)value;
        Matcher m = substitutionPattern.matcher(variable);
        if (!m.matches()) {
            return variable;
        }
        String variableName = m.group("name");
        if (this.secretStore != null && (ssValue = this.secretStore.retrieveSecret(new SecretIdentifier(variableName))) != null) {
            if (keepSecrets) {
                return new SecretVariable(variableName, new String(ssValue, StandardCharsets.UTF_8));
            }
            return new String(ssValue, StandardCharsets.UTF_8);
        }
        if (this.envVarProvider != null && (evValue = this.envVarProvider.get(variableName)) != null) {
            return evValue;
        }
        String defaultValue = m.group("default");
        if (defaultValue == null) {
            throw new IllegalStateException(String.format("Cannot evaluate `%s`. Replacement variable `%s` is not defined in a Logstash secret store or an environment entry and there is no default value given.", variable, variableName));
        }
        return defaultValue;
    }

    public Object expand(Object value) {
        return this.expand(value, false);
    }

    @Override
    public void close() {
    }
}

