/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UDTAliasInfo;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateAliasNode
extends DDLStatementNode {
    public static final int PARAMETER_ARRAY = 0;
    public static final int TABLE_NAME = 1;
    public static final int DYNAMIC_RESULT_SET_COUNT = 2;
    public static final int LANGUAGE = 3;
    public static final int EXTERNAL_NAME = 4;
    public static final int PARAMETER_STYLE = 5;
    public static final int SQL_CONTROL = 6;
    public static final int DETERMINISTIC = 7;
    public static final int NULL_ON_NULL_INPUT = 8;
    public static final int RETURN_TYPE = 9;
    public static final int ROUTINE_SECURITY_DEFINER = 10;
    public static final int VARARGS = 11;
    public static final int ROUTINE_ELEMENT_COUNT = 12;
    private static final String[] NON_RESERVED_FUNCTION_NAMES = new String[]{"ABS", "ABSVAL", "DATE", "DAY", "LCASE", "LENGTH", "MONTH", "SQRT", "TIME", "TIMESTAMP", "UCASE"};
    private static final String[] NON_RESERVED_AGGREGATES = new String[]{"COLLECT", "COUNT", "EVERY", "FUSION", "INTERSECTION", "STDDEV_POP", "STDDEV_SAMP", "VAR_POP", "VAR_SAMP"};
    public static final int AGG_FOR_TYPE = 0;
    public static final int AGG_RETURN_TYPE = 1;
    public static final int AGG_ELEMENT_COUNT = 2;
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private AliasInfo aliasInfo;

    CreateAliasNode(TableName aliasName, Object targetObject, String methodName, Object aliasSpecificInfo, char aliasType, ContextManager cm) throws StandardException {
        super(aliasName, cm);
        this.aliasType = aliasType;
        switch (this.aliasType) {
            case 'G': {
                this.javaClassName = (String)targetObject;
                Object[] aggElements = (Object[])aliasSpecificInfo;
                TypeDescriptor aggForType = this.bindUserCatalogType((TypeDescriptor)aggElements[0]);
                TypeDescriptor aggReturnType = this.bindUserCatalogType((TypeDescriptor)aggElements[1]);
                if (aggForType.getJDBCTypeId() == 2009 || aggReturnType.getJDBCTypeId() == 2009) {
                    throw StandardException.newException((String)"42ZB3", (Object[])new Object[0]);
                }
                this.aliasInfo = new AggregateAliasInfo(aggForType, aggReturnType);
                this.implicitCreateSchema = true;
                break;
            }
            case 'A': {
                this.javaClassName = (String)targetObject;
                this.aliasInfo = new UDTAliasInfo();
                this.implicitCreateSchema = true;
                break;
            }
            case 'F': 
            case 'P': {
                Integer drso;
                this.javaClassName = (String)targetObject;
                this.methodName = methodName;
                Object[] routineElements = (Object[])aliasSpecificInfo;
                Object[] parameters = (Object[])routineElements[0];
                int paramCount = ((List)parameters[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                String[] names = null;
                TypeDescriptor[] types = null;
                int[] modes = null;
                if (paramCount != 0) {
                    names = new String[paramCount];
                    types = new TypeDescriptor[paramCount];
                    modes = new int[paramCount];
                    for (int i = 0; i < paramCount; ++i) {
                        int currentMode;
                        names[i] = (String)((List)parameters[0]).get(i);
                        types[i] = (TypeDescriptor)((List)parameters[1]).get(i);
                        modes[i] = currentMode = ((Integer)((List)parameters[2]).get(i)).intValue();
                        if (types[i].isUserDefinedType() || !TypeId.getBuiltInTypeId(types[i].getJDBCTypeId()).isXMLTypeId()) continue;
                        throw StandardException.newException((String)"42962", (Object[])new Object[]{names[i]});
                    }
                    if (paramCount > 1) {
                        Object[] dupNameCheck = new String[paramCount];
                        System.arraycopy(names, 0, dupNameCheck, 0, paramCount);
                        Arrays.sort(dupNameCheck);
                        for (int dnc = 1; dnc < dupNameCheck.length; ++dnc) {
                            if (((String)dupNameCheck[dnc]).equals("") || !((String)dupNameCheck[dnc]).equals(dupNameCheck[dnc - 1])) continue;
                            throw StandardException.newException((String)"42734", (Object[])new Object[]{dupNameCheck[dnc], this.getFullName()});
                        }
                    }
                }
                int drs = (drso = (Integer)routineElements[2]) == null ? 0 : drso;
                Short sqlAllowedObject = (Short)routineElements[6];
                short sqlAllowed = sqlAllowedObject != null ? sqlAllowedObject : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean isDeterministicO = (Boolean)routineElements[7];
                boolean isDeterministic = isDeterministicO == null ? false : isDeterministicO;
                Boolean hasVarargsO = (Boolean)routineElements[11];
                boolean hasVarargs = hasVarargsO == null ? false : hasVarargsO;
                Boolean definersRightsO = (Boolean)routineElements[10];
                boolean definersRights = definersRightsO == null ? false : definersRightsO;
                Boolean calledOnNullInputO = (Boolean)routineElements[8];
                boolean calledOnNullInput = calledOnNullInputO == null ? true : calledOnNullInputO;
                TypeDescriptor returnType = (TypeDescriptor)routineElements[9];
                if (returnType != null) {
                    DataTypeDescriptor dtd = DataTypeDescriptor.getType(returnType);
                    dtd = this.bindUserType(dtd);
                    returnType = dtd.getCatalogType();
                }
                this.aliasInfo = new RoutineAliasInfo(this.methodName, paramCount, names, types, modes, drs, (Short)routineElements[5], sqlAllowed, isDeterministic, hasVarargs, definersRights, calledOnNullInput, returnType);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName t = (TableName)targetObject;
                String targetSchema = t.getSchemaName() != null ? t.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(targetSchema, t.getTableName());
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected value for aliasType (" + aliasType + ")"));
            }
        }
    }

    @Override
    String statementToString() {
        switch (this.aliasType) {
            case 'G': {
                return "CREATE DERBY AGGREGATE";
            }
            case 'A': {
                return "CREATE TYPE";
            }
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.aliasType == 'F' || this.aliasType == 'P') {
            RoutineAliasInfo rai = (RoutineAliasInfo)this.aliasInfo;
            rai.setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
            this.bindParameterTypes((RoutineAliasInfo)this.aliasInfo);
            if (rai.hasVarargs()) {
                switch (rai.getParameterStyle()) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw StandardException.newException((String)"42ZC9", (Object[])new Object[0]);
                    }
                }
                if (rai.getMaxDynamicResultSets() > 0) {
                    throw StandardException.newException((String)"42ZCB", (Object[])new Object[0]);
                }
            }
            if (rai.getParameterStyle() == 2 && !rai.hasVarargs()) {
                throw StandardException.newException((String)"42ZCA", (Object[])new Object[0]);
            }
        }
        if (this.aliasType == 'A') {
            TypeId[] allSystemTypeIds = TypeId.getAllBuiltinTypeIds();
            int systemTypeCount = allSystemTypeIds.length;
            boolean foundConflict = this.javaClassName.startsWith("org.apache.derby.");
            if (!foundConflict) {
                for (int i = 0; i < systemTypeCount; ++i) {
                    TypeId systemType = allSystemTypeIds[i];
                    String systemTypeName = systemType.getCorrespondingJavaTypeName();
                    if (!systemTypeName.equals(this.javaClassName)) continue;
                    foundConflict = true;
                    break;
                }
            }
            if (foundConflict) {
                throw StandardException.newException((String)"42Z10", (Object[])new Object[]{this.javaClassName});
            }
            return;
        }
        if (this.aliasType == 'G') {
            this.bindAggregate();
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (CreateAliasNode.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
        String targetSchema = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        String targetTable = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals(targetSchema, targetTable)) {
            throw StandardException.newException((String)"42916", (Object[])new Object[]{this.getFullName(), targetSchema + "." + targetTable});
        }
        SchemaDescriptor targetSD = this.getSchemaDescriptor(targetSchema, false);
        if (targetSD != null && this.isSessionSchema(targetSD)) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
    }

    private void bindAggregate() throws StandardException {
        int i;
        String unqualifiedName = this.getRelativeName();
        SchemaDescriptor sysfun = this.getSchemaDescriptor("SYSFUN", true);
        List<AliasDescriptor> systemFunctions = this.getDataDictionary().getRoutineList(sysfun.getUUID().toString(), unqualifiedName, 'F');
        for (i = 0; i < systemFunctions.size(); ++i) {
            AliasDescriptor function = systemFunctions.get(i);
            RoutineAliasInfo routineInfo = (RoutineAliasInfo)function.getAliasInfo();
            int parameterCount = routineInfo.getParameterCount();
            if (parameterCount != 1) continue;
            throw this.illegalAggregate();
        }
        for (i = 0; i < NON_RESERVED_FUNCTION_NAMES.length; ++i) {
            if (!NON_RESERVED_FUNCTION_NAMES[i].equals(unqualifiedName)) continue;
            throw this.illegalAggregate();
        }
        for (i = 0; i < NON_RESERVED_AGGREGATES.length; ++i) {
            if (!NON_RESERVED_AGGREGATES[i].equals(unqualifiedName)) continue;
            throw this.illegalAggregate();
        }
        AggregateAliasInfo aai = (AggregateAliasInfo)this.aliasInfo;
        aai.setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
    }

    private StandardException illegalAggregate() {
        return StandardException.newException((String)"42ZC3", (Object[])new Object[]{this.getRelativeName()});
    }

    private void bindParameterTypes(RoutineAliasInfo aliasInfo) throws StandardException {
        TypeDescriptor[] parameterTypes = aliasInfo.getParameterTypes();
        if (parameterTypes == null) {
            return;
        }
        int count = parameterTypes.length;
        for (int i = 0; i < count; ++i) {
            parameterTypes[i] = this.bindUserCatalogType(parameterTypes[i]);
        }
        aliasInfo.setParameterTypes(parameterTypes);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String schemaName = this.getSchemaDescriptor().getSchemaName();
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), schemaName, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

