/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4;
import org.lwjgl.util.lz4.LZ4StreamInternal;

@NativeType(value="union LZ4_stream_t")
public class LZ4Stream
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    public LZ4Stream(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4Stream.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *[LZ4_STREAMSIZE_VOIDP]")
    public PointerBuffer table() {
        return LZ4Stream.ntable(this.address());
    }

    @NativeType(value="void *")
    public long table(int index) {
        return LZ4Stream.ntable(this.address(), index);
    }

    @NativeType(value="struct LZ4_stream_t_internal")
    public LZ4StreamInternal internal_donotuse() {
        return LZ4Stream.ninternal_donotuse(this.address());
    }

    public static LZ4Stream create(long address) {
        return (LZ4Stream)LZ4Stream.wrap(LZ4Stream.class, (long)address);
    }

    @Nullable
    public static LZ4Stream createSafe(long address) {
        return address == 0L ? null : (LZ4Stream)LZ4Stream.wrap(LZ4Stream.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LZ4Stream.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LZ4Stream.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static PointerBuffer ntable(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)TABLE), (int)LZ4.LZ4_STREAMSIZE_VOIDP);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TABLE + Checks.check((int)index, (int)LZ4.LZ4_STREAMSIZE_VOIDP) * (long)POINTER_SIZE));
    }

    public static LZ4StreamInternal ninternal_donotuse(long struct) {
        return LZ4StreamInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4Stream.__union((Struct.Member[])new Struct.Member[]{LZ4Stream.__array((int)POINTER_SIZE, (int)LZ4.LZ4_STREAMSIZE_VOIDP), LZ4Stream.__member((int)LZ4StreamInternal.SIZEOF, (int)LZ4StreamInternal.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4Stream, Buffer> {
        private static final LZ4Stream ELEMENT_FACTORY = LZ4Stream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4Stream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *[LZ4_STREAMSIZE_VOIDP]")
        public PointerBuffer table() {
            return LZ4Stream.ntable(this.address());
        }

        @NativeType(value="void *")
        public long table(int index) {
            return LZ4Stream.ntable(this.address(), index);
        }

        @NativeType(value="struct LZ4_stream_t_internal")
        public LZ4StreamInternal internal_donotuse() {
            return LZ4Stream.ninternal_donotuse(this.address());
        }
    }
}

