/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import aQute.lib.strings.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collector;

public class ExtList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    @SafeVarargs
    public ExtList(T ... ts) {
        super(ts.length);
        for (T t : ts) {
            this.add(t);
        }
    }

    public ExtList() {
    }

    public ExtList(int size) {
        super(size);
    }

    public ExtList(Collection<? extends T> col) {
        super(col);
    }

    public ExtList(Iterable<? extends T> col) {
        for (T t : col) {
            this.add(t);
        }
    }

    public static ExtList<String> from(String s) {
        return Strings.splitAsStream(s).collect(ExtList.collector());
    }

    public static ExtList<String> from(String s, String delimeter) {
        return Pattern.compile(delimeter).splitAsStream(s).collect(ExtList.collector());
    }

    private static Collector<String, ?, ExtList<String>> collector() {
        return Collector.of(ExtList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public String join() {
        return Strings.join(this);
    }

    public String join(String del) {
        return Strings.join(del, this);
    }
}

