/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThanEqual(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, false, false, false)
 * greaterThanEqual(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, false, false)
 * greaterThanEqual(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, true, false)
 * greaterThanEqual(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, true, true)
 */
#version 400

void main()
{
  double[all(equal(greaterThanEqual(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, false, false, false))) ? 1 : -1] array0;
  double[all(equal(greaterThanEqual(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, false, false))) ? 1 : -1] array1;
  double[all(equal(greaterThanEqual(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, true, false))) ? 1 : -1] array2;
  double[all(equal(greaterThanEqual(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, true, true))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
