/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-0.0lf, -0.0lf, -0.0lf)
 * (0.0lf / dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.0lf, 0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(1.0lf, 1.5686274509803921lf, 1.4184397163120568lf)
 * (-1.3333333333333333lf / dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-0.7984031936127745lf, -2.02020202020202lf, -0.71301247771836lf)
 * (0.85lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-0.6375000000000001lf, -1.0lf, -0.9042553191489362lf)
 * (0.85lf / dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.5089820359281437lf, 1.2878787878787878lf, 0.45454545454545453lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-0.0lf, -0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf / dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(1.0lf, 1.5686274509803921lf, 1.4184397163120568lf)) <= 2.3393510443669356e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf / dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-0.7984031936127745lf, -2.02020202020202lf, -0.71301247771836lf)) <= 2.2862744050925902e-05lf ? 1 : -1] array3;
  double[distance((0.85lf / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-0.6375000000000001lf, -1.0lf, -0.9042553191489362lf)) <= 1.4913362907839214e-05lf ? 1 : -1] array4;
  double[distance((0.85lf / dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.5089820359281437lf, 1.2878787878787878lf, 0.45454545454545453lf)) <= 1.4574999332465262e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
