/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf * dvec2(-0.1lf, -1.2lf)) => dvec2(0.0lf, 0.0lf)
 * (0.0lf * dvec2(-0.42lf, 0.48lf)) => dvec2(0.0lf, 0.0lf)
 * (-1.3333333333333333lf * dvec2(-0.1lf, -1.2lf)) => dvec2(0.13333333333333333lf, 1.5999999999999999lf)
 * (-1.3333333333333333lf * dvec2(-0.42lf, 0.48lf)) => dvec2(0.5599999999999999lf, -0.6399999999999999lf)
 * (0.85lf * dvec2(-0.1lf, -1.2lf)) => dvec2(-0.085lf, -1.02lf)
 * (0.85lf * dvec2(-0.42lf, 0.48lf)) => dvec2(-0.357lf, 0.408lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf * dvec2(-0.1lf, -1.2lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf * dvec2(-0.42lf, 0.48lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf * dvec2(-0.1lf, -1.2lf)), dvec2(0.13333333333333333lf, 1.5999999999999999lf)) <= 1.605545943838973e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf * dvec2(-0.42lf, 0.48lf)), dvec2(0.5599999999999999lf, -0.6399999999999999lf)) <= 8.504116650187719e-06lf ? 1 : -1] array3;
  double[distance((0.85lf * dvec2(-0.1lf, -1.2lf)), dvec2(-0.085lf, -1.02lf)) <= 1.0235355391973452e-05lf ? 1 : -1] array4;
  double[distance((0.85lf * dvec2(-0.42lf, 0.48lf)), dvec2(-0.357lf, 0.408lf)) <= 5.4213743644946715e-06lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
