/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(-2.0, -3.0, true) => -3.0
 * mix(-2.0, -3.0, false) => -2.0
 * mix(-2.0, 3.0, true) => 3.0
 * mix(-2.0, 3.0, false) => -2.0
 * mix(2.0, -3.0, true) => -3.0
 * mix(2.0, -3.0, false) => 2.0
 * mix(2.0, 3.0, true) => 3.0
 * mix(2.0, 3.0, false) => 2.0
 */
#version 150

void main()
{
  float[distance(mix(-2.0, -3.0, true), -3.0) <= 3e-05 ? 1 : -1] array0;
  float[distance(mix(-2.0, -3.0, false), -2.0) <= 2e-05 ? 1 : -1] array1;
  float[distance(mix(-2.0, 3.0, true), 3.0) <= 3e-05 ? 1 : -1] array2;
  float[distance(mix(-2.0, 3.0, false), -2.0) <= 2e-05 ? 1 : -1] array3;
  float[distance(mix(2.0, -3.0, true), -3.0) <= 3e-05 ? 1 : -1] array4;
  float[distance(mix(2.0, -3.0, false), 2.0) <= 2e-05 ? 1 : -1] array5;
  float[distance(mix(2.0, 3.0, true), 3.0) <= 3e-05 ? 1 : -1] array6;
  float[distance(mix(2.0, 3.0, false), 2.0) <= 2e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
