/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(0.0, 0.6666667) => 0.0
 * pow(0.0, 2.0) => 0.0
 * pow(0.6666667, -2.0) => 2.2499998
 * pow(0.6666667, -0.6666667) => 1.3103707
 * pow(0.6666667, 0.6666667) => 0.7631428
 * pow(0.6666667, 2.0) => 0.44444448
 * pow(1.3333334, -2.0) => 0.56249994
 * pow(1.3333334, -0.6666667) => 0.8254818
 * pow(1.3333334, 0.6666667) => 1.2114137
 * pow(1.3333334, 2.0) => 1.7777779
 * pow(2.0, -2.0) => 0.25
 * pow(2.0, -0.6666667) => 0.62996054
 * pow(2.0, 0.6666667) => 1.587401
 * pow(2.0, 2.0) => 4.0
 */
#version 150

void main()
{
  float[distance(pow(0.0, 0.6666667), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(pow(0.0, 2.0), 0.0) <= 0.0 ? 1 : -1] array1;
  float[distance(pow(0.6666667, -2.0), 2.2499998) <= 2.2499999e-05 ? 1 : -1] array2;
  float[distance(pow(0.6666667, -0.6666667), 1.3103707) <= 1.3103707e-05 ? 1 : -1] array3;
  float[distance(pow(0.6666667, 0.6666667), 0.7631428) <= 7.631428e-06 ? 1 : -1] array4;
  float[distance(pow(0.6666667, 2.0), 0.44444448) <= 4.4444446e-06 ? 1 : -1] array5;
  float[distance(pow(1.3333334, -2.0), 0.56249994) <= 5.6249996e-06 ? 1 : -1] array6;
  float[distance(pow(1.3333334, -0.6666667), 0.8254818) <= 8.254818e-06 ? 1 : -1] array7;
  float[distance(pow(1.3333334, 0.6666667), 1.2114137) <= 1.21141375e-05 ? 1 : -1] array8;
  float[distance(pow(1.3333334, 2.0), 1.7777779) <= 1.7777778e-05 ? 1 : -1] array9;
  float[distance(pow(2.0, -2.0), 0.25) <= 2.5e-06 ? 1 : -1] array10;
  float[distance(pow(2.0, -0.6666667), 0.62996054) <= 6.299605e-06 ? 1 : -1] array11;
  float[distance(pow(2.0, 0.6666667), 1.587401) <= 1.5874011e-05 ? 1 : -1] array12;
  float[distance(pow(2.0, 2.0), 4.0) <= 4e-05 ? 1 : -1] array13;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length());
}
