/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(-1.5lf) => 1.5lf
 * abs(-0.75lf) => 0.75lf
 * abs(0.0lf) => 0.0lf
 * abs(0.75lf) => 0.75lf
 * abs(1.5lf) => 1.5lf
 */
#version 400

void main()
{
  double[distance(abs(-1.5lf), 1.5lf) <= 1.5000000000000002e-05lf ? 1 : -1] array0;
  double[distance(abs(-0.75lf), 0.75lf) <= 7.500000000000001e-06lf ? 1 : -1] array1;
  double[distance(abs(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array2;
  double[distance(abs(0.75lf), 0.75lf) <= 7.500000000000001e-06lf ? 1 : -1] array3;
  double[distance(abs(1.5lf), 1.5lf) <= 1.5000000000000002e-05lf ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
