/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;

public class WebSocketHttpFieldsWrapper
extends HttpFields.Mutable.Wrapper {
    private final ServerUpgradeResponse _response;

    public WebSocketHttpFieldsWrapper(HttpFields.Mutable fields, ServerUpgradeResponse response, WebSocketNegotiation negotiation) {
        super(fields);
        this._response = response;
    }

    public HttpField onAddField(HttpField field) {
        if (field.getHeader() != null) {
            return switch (field.getHeader()) {
                case HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL -> {
                    this._response.setAcceptedSubProtocol(field.getValue());
                    yield null;
                }
                case HttpHeader.SEC_WEBSOCKET_EXTENSIONS -> {
                    this._response.addExtensions(ExtensionConfig.parseList((String[])new String[]{field.getValue()}));
                    yield null;
                }
                default -> super.onAddField(field);
            };
        }
        return super.onAddField(field);
    }

    public boolean onRemoveField(HttpField field) {
        if (field.getHeader() != null) {
            return switch (field.getHeader()) {
                case HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL -> {
                    this._response.setAcceptedSubProtocol(null);
                    yield true;
                }
                case HttpHeader.SEC_WEBSOCKET_EXTENSIONS -> {
                    this._response.removeExtensions(ExtensionConfig.parseList((String[])new String[]{field.getValue()}));
                    yield true;
                }
                default -> super.onRemoveField(field);
            };
        }
        return super.onRemoveField(field);
    }

    public HttpFields.Mutable put(HttpField field) {
        if (field.getHeader() == HttpHeader.SEC_WEBSOCKET_EXTENSIONS) {
            this._response.setExtensions(Collections.emptyList());
        }
        return super.put(field);
    }

    public HttpFields.Mutable put(String name, String value) {
        if (HttpHeader.SEC_WEBSOCKET_EXTENSIONS.is(name)) {
            this._response.setExtensions(Collections.emptyList());
        }
        return super.put(name, value);
    }

    public HttpFields.Mutable put(HttpHeader header, HttpHeaderValue value) {
        if (header == HttpHeader.SEC_WEBSOCKET_EXTENSIONS) {
            this._response.setExtensions(Collections.emptyList());
        }
        return super.put(header, value);
    }

    public HttpFields.Mutable put(HttpHeader header, String value) {
        if (header == HttpHeader.SEC_WEBSOCKET_EXTENSIONS) {
            this._response.setExtensions(Collections.emptyList());
        }
        return super.put(header, value);
    }

    public HttpFields.Mutable put(String name, List<String> list) {
        if (HttpHeader.SEC_WEBSOCKET_EXTENSIONS.is(name)) {
            this._response.setExtensions(Collections.emptyList());
        }
        return super.put(name, list);
    }
}

