/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.multitenancy.FirebaseTenantClient;
import com.google.firebase.auth.multitenancy.ListTenantsPage;
import com.google.firebase.auth.multitenancy.Tenant;
import com.google.firebase.auth.multitenancy.TenantAwareFirebaseAuth;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class TenantManager {
    private final FirebaseApp firebaseApp;
    private final FirebaseTenantClient tenantClient;
    private final Map<String, TenantAwareFirebaseAuth> tenantAwareAuths;

    public TenantManager(FirebaseApp firebaseApp) {
        this(firebaseApp, new FirebaseTenantClient(firebaseApp));
    }

    @VisibleForTesting
    TenantManager(FirebaseApp firebaseApp, FirebaseTenantClient tenantClient) {
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.tenantClient = (FirebaseTenantClient)Preconditions.checkNotNull((Object)tenantClient);
        this.tenantAwareAuths = new HashMap<String, TenantAwareFirebaseAuth>();
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.tenantClient.setInterceptor(interceptor);
    }

    public Tenant getTenant(@NonNull String tenantId) throws FirebaseAuthException {
        return this.getTenantOp(tenantId).call();
    }

    public synchronized TenantAwareFirebaseAuth getAuthForTenant(@NonNull String tenantId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0, (Object)"Tenant ID must not be null or empty.");
        if (!this.tenantAwareAuths.containsKey(tenantId)) {
            this.tenantAwareAuths.put(tenantId, TenantAwareFirebaseAuth.fromApp(this.firebaseApp, tenantId));
        }
        return this.tenantAwareAuths.get(tenantId);
    }

    public ApiFuture<Tenant> getTenantAsync(@NonNull String tenantId) {
        return this.getTenantOp(tenantId).callAsync(this.firebaseApp);
    }

    private CallableOperation<Tenant, FirebaseAuthException> getTenantOp(final String tenantId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0, (Object)"Tenant ID must not be null or empty.");
        return new CallableOperation<Tenant, FirebaseAuthException>(){

            @Override
            protected Tenant execute() throws FirebaseAuthException {
                return TenantManager.this.tenantClient.getTenant(tenantId);
            }
        };
    }

    public ListTenantsPage listTenants(@Nullable String pageToken) throws FirebaseAuthException {
        return this.listTenants(pageToken, 100);
    }

    public ListTenantsPage listTenants(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listTenantsOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListTenantsPage> listTenantsAsync(@Nullable String pageToken) {
        return this.listTenantsAsync(pageToken, 100);
    }

    public ApiFuture<ListTenantsPage> listTenantsAsync(@Nullable String pageToken, int maxResults) {
        return this.listTenantsOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListTenantsPage, FirebaseAuthException> listTenantsOp(@Nullable String pageToken, int maxResults) {
        ListTenantsPage.DefaultTenantSource tenantSource = new ListTenantsPage.DefaultTenantSource(this.tenantClient);
        final ListTenantsPage.PageFactory factory = new ListTenantsPage.PageFactory(tenantSource, maxResults, pageToken);
        return new CallableOperation<ListTenantsPage, FirebaseAuthException>(){

            @Override
            protected ListTenantsPage execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public Tenant createTenant(@NonNull Tenant.CreateRequest request) throws FirebaseAuthException {
        return this.createTenantOp(request).call();
    }

    public ApiFuture<Tenant> createTenantAsync(@NonNull Tenant.CreateRequest request) {
        return this.createTenantOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<Tenant, FirebaseAuthException> createTenantOp(final Tenant.CreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Create request must not be null.");
        return new CallableOperation<Tenant, FirebaseAuthException>(){

            @Override
            protected Tenant execute() throws FirebaseAuthException {
                return TenantManager.this.tenantClient.createTenant(request);
            }
        };
    }

    public Tenant updateTenant(@NonNull Tenant.UpdateRequest request) throws FirebaseAuthException {
        return this.updateTenantOp(request).call();
    }

    public ApiFuture<Tenant> updateTenantAsync(@NonNull Tenant.UpdateRequest request) {
        return this.updateTenantOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<Tenant, FirebaseAuthException> updateTenantOp(final Tenant.UpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Update request must not be null.");
        Preconditions.checkArgument((!request.getProperties().isEmpty() ? 1 : 0) != 0, (Object)"Tenant update must have at least one property set.");
        return new CallableOperation<Tenant, FirebaseAuthException>(){

            @Override
            protected Tenant execute() throws FirebaseAuthException {
                return TenantManager.this.tenantClient.updateTenant(request);
            }
        };
    }

    public void deleteTenant(@NonNull String tenantId) throws FirebaseAuthException {
        this.deleteTenantOp(tenantId).call();
    }

    public ApiFuture<Void> deleteTenantAsync(String tenantId) {
        return this.deleteTenantOp(tenantId).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteTenantOp(final String tenantId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0, (Object)"Tenant ID must not be null or empty.");
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                TenantManager.this.tenantClient.deleteTenant(tenantId);
                return null;
            }
        };
    }
}

