/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.traccar.api.BaseResource;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Geofence;
import org.traccar.model.Position;
import org.traccar.model.UserRestrictions;
import org.traccar.reports.CsvExportProvider;
import org.traccar.reports.GpxExportProvider;
import org.traccar.reports.KmlExportProvider;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="positions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PositionResource
extends BaseResource {
    @Inject
    private KmlExportProvider kmlExportProvider;
    @Inject
    private CsvExportProvider csvExportProvider;
    @Inject
    private GpxExportProvider gpxExportProvider;

    @GET
    public Stream<Position> getJson(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="id") List<Long> positionIds, @QueryParam(value="geofenceId") long geofenceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        if (!positionIds.isEmpty()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (long positionId : positionIds) {
                Position position2 = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", positionId)));
                this.permissionsService.checkPermission(Device.class, this.getUserId(), position2.getDeviceId());
                positions.add(position2);
            }
            return positions.stream();
        }
        if (deviceId > 0L) {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
            if (from != null && to != null) {
                this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
                Geofence geofence = geofenceId == 0L ? null : this.storage.getObject(Geofence.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", geofenceId)));
                return PositionUtil.getPositionsStream(this.storage, deviceId, from, to).filter(position -> geofence == null || geofence.containsPosition((Position)position));
            }
            return this.storage.getObjectsStream(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
        }
        return PositionUtil.getLatestPositions(this.storage, this.getUserId()).stream();
    }

    @Path(value="{id}")
    @DELETE
    public Response removeById(@PathParam(value="id") long positionId) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getReadonly);
        Request request = new Request((Columns)new Columns.All(), new Condition.Equals("id", positionId));
        Position position = this.storage.getObject(Position.class, request);
        if (position == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.permissionsService.checkPermission(Device.class, this.getUserId(), position.getDeviceId());
        this.storage.removeObject(Position.class, request);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    public Response remove(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getReadonly);
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        conditions.add(new Condition.Equals("deviceId", deviceId));
        conditions.add(new Condition.Between("fixTime", from, to));
        this.storage.removeObject(Position.class, new Request(Condition.merge(conditions)));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="kml")
    @GET
    @Produces(value={"application/vnd.google-earth.kml+xml"})
    public Response getKml(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.kmlExportProvider.generate(output, deviceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.kml").build();
    }

    @Path(value="csv")
    @GET
    @Produces(value={"text/csv"})
    public Response getCsv(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="geofenceId") long geofenceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.csvExportProvider.generate(output, deviceId, geofenceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.csv").build();
    }

    @Path(value="gpx")
    @GET
    @Produces(value={"application/gpx+xml"})
    public Response getGpx(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        StreamingOutput stream = output -> {
            try {
                this.gpxExportProvider.generate(output, deviceId, from, to);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=positions.gpx").build();
    }
}

