/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class ModuleDeactivator {
    public static final String TO_UNINSTALL = "to_uninstall.txt";
    public static final String TO_DISABLE = "to_disable.txt";
    public static final String TO_ENABLE = "to_enable.txt";
    public static final String CONFIG = "config";
    public static final String MODULES = "Modules";
    private final UpdatingContext context;
    private static String ENABLE_TAG = "<param name=\"enabled\">true</param>";
    private static String DISABLE_TAG = "<param name=\"enabled\">false</param>";

    ModuleDeactivator(UpdatingContext updatingContext) {
        this.context = updatingContext;
    }

    public void delete() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        this.context.setLabel(Localization.getBrandedString("CTL_DeletingFiles"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : UpdateTracking.clusters(true)) {
            boolean bl = hashSet.addAll(ModuleDeactivator.readFilesMarkedForDeleteInCluster(object));
            bl = hashSet.add(ModuleDeactivator.getControlFileForMarkedForDelete(object)) || bl;
            bl = hashSet.add(ModuleDeactivator.getDeactivateLater(object)) || bl;
            if (!bl) continue;
            UpdaterDispatcher.touchLastModified(object);
        }
        this.context.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            ModuleDeactivator.doDelete(file);
            this.context.setProgressValue(n++);
        }
    }

    public void enableDisable(boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        this.context.setLabel(bl ? Localization.getBrandedString("CTL_EnablingFiles") : Localization.getBrandedString("CTL_DisablingFiles"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : UpdateTracking.clusters(true)) {
            hashSet.addAll(ModuleDeactivator.readFilesMarkedForEnableDisableInCluster(object, bl));
            ModuleDeactivator.doDelete(ModuleDeactivator.getControlFileForMarkedForEnableDisable(object, bl));
            if (bl) continue;
            ModuleDeactivator.doDelete(ModuleDeactivator.getDeactivateLater(object));
        }
        this.context.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            ModuleDeactivator.doEnableDisable(file, bl);
            this.context.setProgressValue(n++);
        }
    }

    public static boolean hasModulesForDelete(File file) {
        File file2 = new File(file, "deactivate");
        return file2.exists() && file2.isDirectory() && Arrays.asList(file2.list()).contains(TO_UNINSTALL);
    }

    public static boolean hasModulesForDisable(File file) {
        File file2 = new File(file, "deactivate");
        return file2.exists() && file2.isDirectory() && Arrays.asList(file2.list()).contains(TO_DISABLE);
    }

    public static boolean hasModulesForEnable(File file) {
        File file2 = new File(file, "deactivate");
        return file2.exists() && file2.isDirectory() && Arrays.asList(file2.list()).contains(TO_ENABLE);
    }

    public static File getDeactivateLater(File file) {
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + "deactivate_later.txt");
        return file2;
    }

    public static File getControlFileForMarkedForDelete(File file) {
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + TO_UNINSTALL);
        return file2;
    }

    public static File getControlFileForMarkedForEnableDisable(File file, boolean bl) {
        String string = bl ? TO_ENABLE : TO_DISABLE;
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + string);
        return file2;
    }

    public static void writeStringToFile(String string, File file) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string);
                XMLUtil.LOG.info("File " + file + " modified.");
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            XMLUtil.LOG.log(Level.SEVERE, "Cannot write " + file, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(File file) {
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                int n;
                stringBuffer = new StringBuffer();
                bufferedReader = new BufferedReader(new FileReader(file));
                char[] cArray = new char[1024];
                while ((n = bufferedReader.read(cArray)) != -1) {
                    String string = String.valueOf(cArray, 0, n);
                    stringBuffer.append(string);
                    cArray = new char[1024];
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException iOException) {
            XMLUtil.LOG.log(Level.SEVERE, "Cannot read " + file, iOException);
        }
        return stringBuffer == null ? "" : stringBuffer.toString();
    }

    private static void doDelete(File file) {
        assert (file != null) : "Invalid file " + file + " for delete.";
        if (!file.exists()) {
            return;
        }
        XMLUtil.LOG.info("Deleting file: " + file);
        if (!file.delete()) {
            file.deleteOnExit();
            XMLUtil.LOG.info("File " + file + " cannot be deleted. Will be delete later on exit.");
        } else {
            XMLUtil.LOG.info("File " + file + " deleted.");
        }
        for (file = file.getParentFile(); file != null && ModuleDeactivator.doDeleteEmptyDirectory(file); file = file.getParentFile()) {
        }
    }

    private static boolean doDeleteEmptyDirectory(File file) {
        boolean bl;
        assert (file != null) : file + " cannot be null";
        if (file.isDirectory()) {
            File file2;
            List<File> list = Arrays.asList(file.listFiles());
            if (list.size() == 1 && ".lastModified".endsWith((file2 = list.get(0)).getName())) {
                if (file2.delete()) {
                    file.delete();
                }
                XMLUtil.LOG.info("File " + file2 + " deleted.");
            }
            bl = file.delete();
            XMLUtil.LOG.info("Directory " + file + " deleted.");
        } else {
            bl = file.delete();
            XMLUtil.LOG.info("File " + file + " deleted.");
        }
        return bl;
    }

    private static Set<File> readFilesMarkedForDeleteInCluster(File file) {
        File file2 = ModuleDeactivator.getControlFileForMarkedForDelete(file);
        if (!file2.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        String string = ModuleDeactivator.readStringFromFile(file2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, UpdateTracking.PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            File file3 = new File(string2);
            if (!file3.exists()) continue;
            hashSet.add(file3);
        }
        return hashSet;
    }

    private static Set<File> readFilesMarkedForEnableDisableInCluster(File file, boolean bl) {
        File file2 = ModuleDeactivator.getControlFileForMarkedForEnableDisable(file, bl);
        if (!file2.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        String string = ModuleDeactivator.readStringFromFile(file2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, UpdateTracking.PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            File file3 = new File(string2);
            if (!file3.exists()) continue;
            hashSet.add(file3);
        }
        return hashSet;
    }

    private static void doEnableDisable(File file, boolean bl) {
        String string = bl ? DISABLE_TAG : ENABLE_TAG;
        String string2 = bl ? ENABLE_TAG : DISABLE_TAG;
        String string3 = ModuleDeactivator.readStringFromFile(file);
        if (!string3.contains(string2)) {
            int n = string3.indexOf(string);
            assert (n != -1) : string + " must be contained in " + string3;
            int n2 = string.length();
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + n2);
            string3 = string4 + string2 + string5;
        }
        File file2 = new File(new File(UpdateTracking.getUserDir(), CONFIG), MODULES);
        file2.mkdirs();
        File file3 = new File(file2, file.getName());
        ModuleDeactivator.writeStringToFile(string3, file3);
    }
}

