/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.AllocationSettingsWrapper;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocator;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.PacketHandler;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.util.BooleanStateTimeTracker;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002bcB?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010,\u001a\u00020'J\u0006\u00106\u001a\u000207J\u0006\u0010>\u001a\u000207J\u0006\u0010?\u001a\u000208J\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020'J\u000e\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020HJ\u000e\u0010F\u001a\u00020'2\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020'2\u0006\u0010I\u001a\u00020JJ\u000e\u0010L\u001a\u00020'2\u0006\u0010G\u001a\u00020HJ\u000e\u0010Q\u001a\u0002072\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\u0002072\u0006\u0010U\u001a\u00020VJ\u000e\u0010W\u001a\u00020'2\u0006\u0010X\u001a\u00020YJ\u000e\u0010Z\u001a\u00020'2\u0006\u0010X\u001a\u00020YJ\u0006\u0010[\u001a\u00020\\J\u0014\u0010]\u001a\u000207*\u00020#2\u0006\u0010^\u001a\u00020EH\u0002J\u0014\u0010_\u001a\u000207*\u00020#2\u0006\u0010`\u001a\u00020aH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f0\u0017R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R$\u00109\u001a\u0002082\u0006\u0010\u0018\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0011\u0010M\u001a\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006d"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController;", "T", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "", "eventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "endpointsSupplier", "Ljava/util/function/Supplier;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;Ljava/util/function/Supplier;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "eventEmitter", "Lorg/jitsi/utils/event/SyncEventEmitter;", "getEventEmitter", "()Lorg/jitsi/utils/event/SyncEventEmitter;", "logger", "bitrateAllocatorEventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "value", "", "", "forwardedSources", "getForwardedSources", "()Ljava/util/Set;", "oversendingTimeTracker", "Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "getOversendingTimeTracker", "()Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "supportsRtx", "", "packetHandler", "Lorg/jitsi/videobridge/cc/allocation/PacketHandler;", "bandwidthAllocator", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator;", "hasSuspendedSources", "allocationSettingsWrapper", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettingsWrapper;", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "getAllocationSettings", "()Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "trustBwe", "getTrustBwe", "()Z", "endpointOrderingChanged", "", "", "lastN", "getLastN", "()I", "setLastN", "(I)V", "expire", "numForwardedSources", "getTotalOversendingTime", "Ljava/time/Duration;", "isOversending", "bandwidthChanged", "newBandwidthBps", "", "accept", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "transformRtcp", "transformRtp", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "isOnStageOrSelected", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "hasNonZeroEffectiveConstraints", "getStatusSnapshot", "Lorg/jitsi/videobridge/cc/allocation/BitrateControllerStatusSnapshot;", "logBweChange", "newBweBps", "logAllocationChange", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "EventHandler", "BitrateAllocatorEventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nBitrateController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitrateController.kt\norg/jitsi/videobridge/cc/allocation/BitrateController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1855#2:335\n1856#2:337\n1855#2,2:338\n1#3:336\n*S KotlinDebug\n*F\n+ 1 BitrateController.kt\norg/jitsi/videobridge/cc/allocation/BitrateController\n*L\n203#1:335\n203#1:337\n248#1:338,2\n*E\n"})
public final class BitrateController<T extends MediaSourceContainer> {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Clock clock;
    @NotNull
    private final SyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final BitrateAllocatorEventHandler bitrateAllocatorEventHandler;
    @NotNull
    private Set<String> forwardedSources;
    @NotNull
    private final BooleanStateTimeTracker oversendingTimeTracker;
    @Nullable
    private final TimeSeriesLogger timeSeriesLogger;
    private boolean supportsRtx;
    @NotNull
    private final PacketHandler packetHandler;
    @NotNull
    private final BandwidthAllocator<T> bandwidthAllocator;
    @NotNull
    private final AllocationSettingsWrapper allocationSettingsWrapper;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, @NotNull Clock clock) {
        void it;
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.diagnosticContext = diagnosticContext;
        this.clock = clock;
        this.eventEmitter = new SyncEventEmitter();
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.bitrateAllocatorEventHandler = new BitrateAllocatorEventHandler();
        this.forwardedSources = SetsKt.emptySet();
        this.oversendingTimeTracker = new BooleanStateTimeTracker(false, null, 3, null);
        TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BitrateController.class);
        BitrateController bitrateController2 = this;
        boolean bl = false;
        bitrateController2.timeSeriesLogger = it.isTraceEnabled() ? it : null;
        this.packetHandler = new PacketHandler(this.clock, parentLogger, this.diagnosticContext, (EventEmitter<EventHandler>)this.eventEmitter);
        this.bandwidthAllocator = new BandwidthAllocator<T>(this.bitrateAllocatorEventHandler, endpointsSupplier, () -> BitrateController.bandwidthAllocator$lambda$1(this), parentLogger, this.diagnosticContext, this.clock);
        this.allocationSettingsWrapper = new AllocationSettingsWrapper(parentLogger);
        this.eventEmitter.addHandler(eventHandler);
    }

    public /* synthetic */ BitrateController(EventHandler eventHandler, Supplier supplier, DiagnosticContext diagnosticContext, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x10) != 0) {
            clock = Clock.systemUTC();
        }
        this(eventHandler, supplier, diagnosticContext, logger, clock);
    }

    @NotNull
    public final SyncEventEmitter<EventHandler> getEventEmitter() {
        return this.eventEmitter;
    }

    @NotNull
    public final Set<String> getForwardedSources() {
        return this.forwardedSources;
    }

    @NotNull
    public final BooleanStateTimeTracker getOversendingTimeTracker() {
        return this.oversendingTimeTracker;
    }

    @Nullable
    public final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    public final boolean hasSuspendedSources() {
        return this.bandwidthAllocator.getAllocation().getHasSuspendedSources();
    }

    @NotNull
    public final AllocationSettings getAllocationSettings() {
        return this.allocationSettingsWrapper.get();
    }

    private final boolean getTrustBwe() {
        return BitrateControllerConfig.config.getTrustBwe() && this.supportsRtx && this.packetHandler.timeSinceFirstMedia().compareTo(DurationKt.getSecs(10)) >= 0;
    }

    public final void endpointOrderingChanged() {
        this.bandwidthAllocator.update();
    }

    public final int getLastN() {
        return this.allocationSettingsWrapper.getLastN$jitsi_videobridge();
    }

    public final void setLastN(int value2) {
        if (this.allocationSettingsWrapper.setLastN(value2)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final void expire() {
        this.bandwidthAllocator.expire();
    }

    public final int numForwardedSources() {
        return this.forwardedSources.size();
    }

    @NotNull
    public final Duration getTotalOversendingTime() {
        return this.oversendingTimeTracker.totalTimeOn();
    }

    public final boolean isOversending() {
        return this.oversendingTimeTracker.getState();
    }

    public final void bandwidthChanged(long newBandwidthBps) {
        TimeSeriesLogger timeSeriesLogger = this.timeSeriesLogger;
        if (timeSeriesLogger != null) {
            this.logBweChange(timeSeriesLogger, newBandwidthBps);
        }
        this.bandwidthAllocator.bandwidthChanged(newBandwidthBps);
    }

    public final boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (packetInfo.getLayeringChanged()) {
            this.logger.debug(() -> BitrateController.accept$lambda$2(packetInfo));
            this.bandwidthAllocator.update();
        }
        return this.packetHandler.accept(packetInfo);
    }

    public final boolean accept(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        return this.packetHandler.accept(rtcpSrPacket);
    }

    public final boolean transformRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        return this.packetHandler.transformRtcp(rtcpSrPacket);
    }

    public final boolean transformRtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        return this.packetHandler.transformRtp(packetInfo);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u243 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_debugState__u24lambda_u243.put("bitrate_allocator", this.bandwidthAllocator.getDebugState());
        $this$_get_debugState__u24lambda_u243.put("packet_handler", this.packetHandler.getDebugState());
        $this$_get_debugState__u24lambda_u243.put("forwardedSources", this.forwardedSources.toString());
        $this$_get_debugState__u24lambda_u243.put("oversending", this.oversendingTimeTracker.getState());
        $this$_get_debugState__u24lambda_u243.put("total_oversending_time_secs", this.oversendingTimeTracker.totalTimeOn().getSeconds());
        $this$_get_debugState__u24lambda_u243.put("supportsRtx", this.supportsRtx);
        $this$_get_debugState__u24lambda_u243.put("trust_bwe", this.getTrustBwe());
        return jSONObject;
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        if (payloadType.getEncoding() == PayloadTypeEncoding.RTX) {
            this.supportsRtx = true;
        }
    }

    public final void setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.allocationSettingsWrapper.setBandwidthAllocationSettings(message)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final boolean isOnStageOrSelected(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        return this.getAllocationSettings().getOnStageSources().contains(source.getSourceName()) || this.getAllocationSettings().getSelectedSources().contains(source.getSourceName());
    }

    public final boolean hasNonZeroEffectiveConstraints(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        return this.bandwidthAllocator.hasNonZeroEffectiveConstraints$jitsi_videobridge(source);
    }

    @NotNull
    public final BitrateControllerStatusSnapshot getStatusSnapshot() {
        double totalTargetBitrate = 0.0;
        totalTargetBitrate = BandwidthKt.getBps(0);
        double totalIdealBitrate = 0.0;
        totalIdealBitrate = BandwidthKt.getBps(0);
        Set activeSsrcs = new LinkedHashSet();
        boolean hasNonIdealLayer = false;
        long nowMs = this.clock.instant().toEpochMilli();
        BandwidthAllocation allocation = this.bandwidthAllocator.getAllocation();
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object allocationIdealBitrate;
            Object object;
            Bandwidth allocationTargetBitrate;
            SingleAllocation singleAllocation = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc = singleAllocation.getTargetLayer();
            Bandwidth bandwidth = allocationTargetBitrate = rtpLayerDesc != null ? Bandwidth.box-impl(rtpLayerDesc.getBitrate-WElJv5I(nowMs)) : null;
            if (bandwidth != null) {
                double it = bandwidth.unbox-impl();
                boolean bl2 = false;
                totalTargetBitrate = Bandwidth.plus-GI7mN98(totalTargetBitrate, it);
                MediaSourceDesc mediaSourceDesc = singleAllocation.getMediaSource();
                if (mediaSourceDesc != null) {
                    long primarySsrc = mediaSourceDesc.getPrimarySSRC();
                    boolean bl3 = false;
                    activeSsrcs.add(primarySsrc);
                }
            }
            if (BitrateControllerConfig.config.getUseVlaTargetBitrate()) {
                object = singleAllocation.getIdealLayer();
                if (object == null || (object = ((RtpLayerDesc)object).getTargetBitrate-4yB3KFE()) == null) {
                    RtpLayerDesc rtpLayerDesc2 = singleAllocation.getIdealLayer();
                    object = rtpLayerDesc2 != null ? Bandwidth.box-impl(rtpLayerDesc2.getBitrate-WElJv5I(nowMs)) : null;
                }
            } else {
                RtpLayerDesc rtpLayerDesc3 = singleAllocation.getIdealLayer();
                object = rtpLayerDesc3 != null ? Bandwidth.box-impl(rtpLayerDesc3.getBitrate-WElJv5I(nowMs)) : null;
            }
            Object object2 = allocationIdealBitrate = object;
            if (object2 != null) {
                double it = ((Bandwidth)object2).unbox-impl();
                boolean bl4 = false;
                totalIdealBitrate = Bandwidth.plus-GI7mN98(totalIdealBitrate, it);
            }
            if (singleAllocation.getIdealLayer() == null || Intrinsics.areEqual(singleAllocation.getIdealLayer(), singleAllocation.getTargetLayer())) continue;
            hasNonIdealLayer = true;
        }
        activeSsrcs.removeIf(arg_0 -> BitrateController.getStatusSnapshot$lambda$9(BitrateController::getStatusSnapshot$lambda$8, arg_0));
        return new BitrateControllerStatusSnapshot((long)totalTargetBitrate, (long)totalIdealBitrate, activeSsrcs, hasNonIdealLayer);
    }

    private final void logBweChange(TimeSeriesLogger $this$logBweChange, long newBweBps) {
        $this$logBweChange.trace(this.diagnosticContext.makeTimeSeriesPoint("new_bwe").addField("bwe_bps", newBweBps));
    }

    private final void logAllocationChange(TimeSeriesLogger $this$logAllocationChange, BandwidthAllocation allocation) {
        long nowMs = this.clock.millis();
        double totalTargetBps = 0.0;
        double totalIdealBps = 0.0;
        double totalTargetMeasuredBps = 0.0;
        double totalIdealMeasuredBps = 0.0;
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Object object3;
            double bitrate;
            Object object4;
            double bitrate2;
            SingleAllocation it = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc = it.getTargetLayer();
            if (rtpLayerDesc != null) {
                bitrate2 = rtpLayerDesc.getBitrate-WElJv5I(nowMs);
                boolean bl2 = false;
                totalTargetBps += bitrate2;
            }
            RtpLayerDesc rtpLayerDesc2 = it.getIdealLayer();
            if (rtpLayerDesc2 != null) {
                bitrate2 = rtpLayerDesc2.getBitrate-WElJv5I(nowMs);
                boolean bl3 = false;
                totalIdealBps += bitrate2;
            }
            if ((object4 = it.getTargetLayer()) != null && (object4 = ((RtpLayerDesc)object4).getTargetBitrate-4yB3KFE()) != null) {
                bitrate = ((Bandwidth)object4).unbox-impl();
                boolean bl4 = false;
                totalTargetMeasuredBps += bitrate;
            }
            if ((object3 = it.getIdealLayer()) != null && (object3 = ((RtpLayerDesc)object3).getTargetBitrate-4yB3KFE()) != null) {
                bitrate = ((Bandwidth)object3).unbox-impl();
                boolean bl5 = false;
                totalIdealMeasuredBps += bitrate;
            }
            RtpLayerDesc rtpLayerDesc3 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc4 = it.getIdealLayer();
            RtpLayerDesc rtpLayerDesc5 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc6 = it.getIdealLayer();
            $this$logAllocationChange.trace(this.diagnosticContext.makeTimeSeriesPoint("allocation_for_source", nowMs).addField("remote_endpoint_id", it.getEndpointId()).addField("target_idx", rtpLayerDesc3 != null ? rtpLayerDesc3.getIndex() : -1).addField("ideal_idx", rtpLayerDesc4 != null ? rtpLayerDesc4.getIndex() : -1).addField("target_bps_measured", rtpLayerDesc5 != null ? (Number)rtpLayerDesc5.getBitrate-WElJv5I(nowMs) : (Number)-1).addField("target_bps", (object2 = it.getTargetLayer()) != null && (object2 = ((RtpLayerDesc)object2).getTargetBitrate-4yB3KFE()) != null ? (Number)((Bandwidth)object2).unbox-impl() : (Number)-1).addField("ideal_bps_measured", rtpLayerDesc6 != null ? (Number)rtpLayerDesc6.getBitrate-WElJv5I(nowMs) : (Number)-1).addField("ideal_bps", (object = it.getIdealLayer()) != null && (object = ((RtpLayerDesc)object).getTargetBitrate-4yB3KFE()) != null ? (Number)((Bandwidth)object).unbox-impl() : (Number)-1));
        }
        $this$logAllocationChange.trace(this.diagnosticContext.makeTimeSeriesPoint("allocation", nowMs).addField("total_target_bps", totalTargetBps).addField("total_ideal_bps", totalIdealBps).addField("total_target_measured_bps", totalTargetMeasuredBps).addField("total_ideal_measured_bps", totalIdealMeasuredBps));
    }

    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(eventHandler, endpointsSupplier, diagnosticContext, parentLogger, null, 16, null);
    }

    private static final Boolean bandwidthAllocator$lambda$1(BitrateController this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getTrustBwe();
    }

    private static final String accept$lambda$2(PacketInfo $packetInfo) {
        Intrinsics.checkNotNullParameter($packetInfo, "$packetInfo");
        return "Layering information changed for packet from " + $packetInfo.getEndpointId() + ", updating bandwidth allocation";
    }

    private static final boolean getStatusSnapshot$lambda$8(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it < 0L;
    }

    private static final boolean getStatusSnapshot$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J=\u0010\b\u001a\u00020\u00052\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\n2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\nH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "<init>", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController;)V", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "newEffectiveConstraints", "(Ljava/util/Map;Ljava/util/Map;)V", "jitsi-videobridge"})
    private final class BitrateAllocatorEventHandler
    implements BandwidthAllocator.EventHandler {
        @Override
        public void allocationChanged(@NotNull BandwidthAllocation allocation) {
            Intrinsics.checkNotNullParameter(allocation, "allocation");
            TimeSeriesLogger timeSeriesLogger = BitrateController.this.getTimeSeriesLogger();
            if (timeSeriesLogger != null) {
                BitrateController.this.logAllocationChange(timeSeriesLogger, allocation);
            }
            BitrateController.this.packetHandler.allocationChanged(allocation);
            Set<String> newForwardedSources = allocation.getForwardedSources();
            if (!Intrinsics.areEqual(BitrateController.this.getForwardedSources(), newForwardedSources)) {
                BitrateController.this.forwardedSources = newForwardedSources;
                BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.allocationChanged$lambda$0(newForwardedSources, arg_0));
            }
            BitrateController.this.getOversendingTimeTracker().setState(allocation.getOversending());
            BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.allocationChanged$lambda$1(allocation, arg_0));
        }

        @Override
        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, @NotNull Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
            Intrinsics.checkNotNullParameter(oldEffectiveConstraints, "oldEffectiveConstraints");
            Intrinsics.checkNotNullParameter(newEffectiveConstraints, "newEffectiveConstraints");
            BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.effectiveVideoConstraintsChanged$lambda$2(oldEffectiveConstraints, newEffectiveConstraints, arg_0));
        }

        private static final Unit allocationChanged$lambda$0(Set $newForwardedSources, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter($newForwardedSources, "$newForwardedSources");
            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
            $this$fireEvent.forwardedSourcesChanged($newForwardedSources);
            return Unit.INSTANCE;
        }

        private static final Unit allocationChanged$lambda$1(BandwidthAllocation $allocation, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter($allocation, "$allocation");
            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
            $this$fireEvent.allocationChanged($allocation);
            return Unit.INSTANCE;
        }

        private static final Unit effectiveVideoConstraintsChanged$lambda$2(Map $oldEffectiveConstraints, Map $newEffectiveConstraints, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter($oldEffectiveConstraints, "$oldEffectiveConstraints");
            Intrinsics.checkNotNullParameter($newEffectiveConstraints, "$newEffectiveConstraints");
            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
            $this$fireEvent.effectiveVideoConstraintsChanged($oldEffectiveConstraints, $newEffectiveConstraints);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J=\u0010\u0007\u001a\u00020\u00032\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\t2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\tH&\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "", "forwardedSourcesChanged", "", "forwardedSources", "", "", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "newEffectiveConstraints", "(Ljava/util/Map;Ljava/util/Map;)V", "keyframeNeeded", "endpointId", "ssrc", "", "allocationChanged", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "jitsi-videobridge"})
    public static interface EventHandler {
        public void forwardedSourcesChanged(@NotNull Set<String> var1);

        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> var1, @NotNull Map<MediaSourceDesc, VideoConstraints> var2);

        public void keyframeNeeded(@Nullable String var1, long var2);

        public void allocationChanged(@NotNull BandwidthAllocation var1);

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void allocationChanged(@NotNull EventHandler $this, @NotNull BandwidthAllocation allocation) {
                Intrinsics.checkNotNullParameter(allocation, "allocation");
            }
        }
    }
}

