/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeCodec;

class UrlFormCodec
implements MediaTypeCodec {
    UrlFormCodec() {
    }

    @Override
    public Object decodeContent(Object content, MediaType contentType) throws UnsupportedEncodingException {
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            content = content instanceof byte[] ? URLDecoder.decode(new String((byte[])content), contentType.getCharset().toString()) : URLDecoder.decode(content.toString(), contentType.getCharset().toString());
            return content.toString().getBytes(StandardCharsets.UTF_8);
        }
        return content;
    }

    @Override
    public Object encodeContent(Object content, MediaType destinationType) throws UnsupportedEncodingException {
        if (destinationType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            content = content instanceof String ? (Object)URLEncoder.encode(content.toString(), destinationType.getCharset().toString()).getBytes(destinationType.getCharset()) : (Object)URLEncoder.encode(new String((byte[])content), destinationType.getCharset().toString()).getBytes(destinationType.getCharset());
        }
        return content;
    }
}

