/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(dvec3(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf)) => dvec3(-2.0lf, -1.0lf, -0.0lf)
 * trunc(dvec3(-0.2857142857142858lf, 0.2857142857142856lf, 0.8571428571428568lf)) => dvec3(-0.0lf, 0.0lf, 0.0lf)
 * trunc(dvec3(1.4285714285714284lf, 2.0lf, 0.0lf)) => dvec3(1.0lf, 2.0lf, 0.0lf)
 * trunc(dvec3(45027112.98414lf, -45027112.98414lf, 19584198736.47329lf)) => dvec3(45027112.0lf, -45027112.0lf, 19584198736.0lf)
 * trunc(dvec3(-19584198736.47329lf, 7.51654162319e+17lf, -7.51654162319e+17lf)) => dvec3(-19584198736.0lf, 7.51654162319e+17lf, -7.51654162319e+17lf)
 * trunc(dvec3(4.502711234095857e+19lf, -4.502711234095857e+19lf, 8.654196813385455e+39lf)) => dvec3(4.502711234095857e+19lf, -4.502711234095857e+19lf, 8.654196813385455e+39lf)
 * trunc(dvec3(-8.654196813385455e+39lf, 6.54965168513655e+83lf, -6.54965168513655e+83lf)) => dvec3(-8.654196813385455e+39lf, 6.54965168513655e+83lf, -6.54965168513655e+83lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(trunc(dvec3(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf)), dvec3(-2.0lf, -1.0lf, -0.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(trunc(dvec3(-0.2857142857142858lf, 0.2857142857142856lf, 0.8571428571428568lf)), dvec3(-0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance(trunc(dvec3(1.4285714285714284lf, 2.0lf, 0.0lf)), dvec3(1.0lf, 2.0lf, 0.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array2;
  double[distance(trunc(dvec3(45027112.98414lf, -45027112.98414lf, 19584198736.47329lf)), dvec3(45027112.0lf, -45027112.0lf, 19584198736.0lf)) <= 195843.02260044246lf ? 1 : -1] array3;
  double[distance(trunc(dvec3(-19584198736.47329lf, 7.51654162319e+17lf, -7.51654162319e+17lf)), dvec3(-19584198736.0lf, 7.51654162319e+17lf, -7.51654162319e+17lf)) <= 10629995105657.18lf ? 1 : -1] array4;
  double[distance(trunc(dvec3(4.502711234095857e+19lf, -4.502711234095857e+19lf, 8.654196813385455e+39lf)), dvec3(4.502711234095857e+19lf, -4.502711234095857e+19lf, 8.654196813385455e+39lf)) <= 8.654196813385455e+34lf ? 1 : -1] array5;
  double[distance(trunc(dvec3(-8.654196813385455e+39lf, 6.54965168513655e+83lf, -6.54965168513655e+83lf)), dvec3(-8.654196813385455e+39lf, 6.54965168513655e+83lf, -6.54965168513655e+83lf)) <= 9.262606241939906e+78lf ? 1 : -1] array6;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
