
# 11 "plugins/ltac/g_auto.mlg"
 

open Pp
open Stdarg
open Pcoq.Prim
open Pcoq.Constr
open Pltac
open Hints



let _ = Mltop.add_known_module "coq-core.plugins.ltac"
let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "eassumption" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eassumption", Tacentries.TyNil), 
           (fun ist -> 
# 28 "plugins/ltac/g_auto.mlg"
                         Eauto.e_assumption 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "eexact" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eexact", Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                          Tacentries.TyNil)), 
           (fun c ist -> 
# 32 "plugins/ltac/g_auto.mlg"
                              Eauto.e_give_exact c 
           )))]


# 35 "plugins/ltac/g_auto.mlg"
 

let pr_hintbases _prc _prlc _prt = Pptactic.pr_hintbases



let (wit_hintbases, hintbases) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"hintbases" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                          [(Pcoq.Production.make
                                                            (Pcoq.Rule.stop)
                                                            (fun loc -> 
# 46 "plugins/ltac/g_auto.mlg"
           Some [] 
                                                                    ));
                                                          (Pcoq.Production.make
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Pcoq.terminal "with"))))
                                                           ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm preident)))))
                                                           (fun l _ loc -> 
# 45 "plugins/ltac/g_auto.mlg"
                                      Some l 
                                                                    ));
                                                          (Pcoq.Production.make
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Pcoq.terminal "with"))))
                                                           ((Pcoq.Symbol.token (Pcoq.terminal "*"))))
                                                           (fun _ _ loc -> 
# 44 "plugins/ltac/g_auto.mlg"
                      None 
                                                                    ))]);
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.Val.Opt 
                                                      (Geninterp.Val.List 
                                                      (Geninterp.val_tag (Genarg.topwit wit_preident))));
                                 Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                         (Genarg.ListArg 
                                                         (wit_preident)));
                                 Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                        (Genarg.ListArg 
                                                        (wit_preident)));
                                 Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                         (Genarg.ListArg 
                                                         (wit_preident)));
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                          ), (fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                          ), (fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                          ));
                                 }
let _ = (wit_hintbases, hintbases)


# 49 "plugins/ltac/g_auto.mlg"
 

let eval_uconstrs ist cs =
  let flags = Pretyping.{
    use_coercions = true;
    use_typeclasses = NoUseTC;
    solve_unification_constraints = true;
    fail_evar = false;
    expand_evars = true;
    program_mode = false;
    polymorphic = false;
    undeclared_evars_patvars = false;
    patvars_abstract = false;
    unconstrained_sorts = false;
  } in
  let map c env sigma = c env sigma in
  List.map (fun c -> map (Tacinterp.type_uconstr ~flags ist c)) cs

let pr_auto_using_raw env sigma _ _ _  = Pptactic.pr_auto_using @@ Ppconstr.pr_constr_expr env sigma
let pr_auto_using_glob env sigma _ _ _ = Pptactic.pr_auto_using (fun (c,_) ->
    Printer.pr_glob_constr_env env sigma c)
let pr_auto_using env sigma _ _ _ = Pptactic.pr_auto_using @@
     Printer.pr_closed_glob_env env sigma



let (wit_auto_using, auto_using) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"auto_using" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            [(Pcoq.Production.make
                                                              (Pcoq.Rule.stop)
                                                              (fun loc -> 
# 81 "plugins/ltac/g_auto.mlg"
           [] 
                                                                    ));
                                                            (Pcoq.Production.make
                                                             (Pcoq.Rule.next 
                                                             (Pcoq.Rule.next 
                                                             (Pcoq.Rule.stop)
                                                             ((Pcoq.Symbol.token (Pcoq.terminal "using"))))
                                                             ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm uconstr)) ((Pcoq.Symbol.rules 
                                                             [Pcoq.Rules.make 
                                                             (Pcoq.Rule.next_norec 
                                                             (Pcoq.Rule.stop)
                                                             ((Pcoq.Symbol.token (Pcoq.terminal ","))))
                                                             (fun _ loc ->
                                                             ())])) false)))
                                                             (fun l _ loc ->
                                                             
# 80 "plugins/ltac/g_auto.mlg"
                                               l 
                                                             ))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.List 
                                                        (Geninterp.val_tag (Genarg.topwit wit_uconstr)));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.ListArg 
                                                           (wit_uconstr));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.ListArg 
                                                          (wit_uconstr));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.ListArg 
                                                           (wit_uconstr));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 78 "plugins/ltac/g_auto.mlg"
                   pr_auto_using_raw env sigma 
                                                            ), (fun env sigma -> 
                                                            
# 79 "plugins/ltac/g_auto.mlg"
                    pr_auto_using_glob env sigma 
                                                            ), (fun env sigma -> 
                                                            
# 77 "plugins/ltac/g_auto.mlg"
               pr_auto_using env sigma 
                                                            ));
                                   }
let _ = (wit_auto_using, auto_using)

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("trivial", Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                           Tacentries.TyNil))), 
           (fun lems db ist -> 
# 88 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "info_trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_trivial", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                                Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                Tacentries.TyNil))), 
           (fun lems db ist -> 
# 93 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial ~debug:Info (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "debug_trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("trivial", 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil)))), 
           (fun lems db ist -> 
# 98 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial ~debug:Debug (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("auto", Tacentries.TyArg (
                                                        Extend.TUopt (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                        Tacentries.TyNil)))), 
           (fun n lems db ist -> 
# 103 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto n (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "info_auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_auto", Tacentries.TyArg (
                                                             Extend.TUopt (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                             Tacentries.TyNil)))), 
           (fun n lems db ist -> 
# 108 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto ~debug:Info n (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "debug_auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("auto", 
                                                         Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil))))), 
           (fun n lems db ist -> 
# 113 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto ~debug:Debug n (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eauto", Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil)))), 
           (fun depth lems db ist -> 
# 120 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ?depth (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "debug_eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("eauto", 
                                                         Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil))))), 
           (fun depth lems db ist -> 
# 125 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ~debug:Debug ?depth (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "info_eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_eauto", Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                              Tacentries.TyNil)))), 
           (fun depth lems db ist -> 
# 130 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ~debug:Info ?depth (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "dfs_eauto" ~level:0 ~deprecation:( Deprecation.make ~since:"8.16" ~note:"Use [eauto] instead." () ) 
         [(Tacentries.TyML (Tacentries.TyIdent ("dfs", Tacentries.TyIdent ("eauto", 
                                                       Tacentries.TyArg (
                                                       Extend.TUopt (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                       Tacentries.TyNil))))), 
           (fun depth lems db ist -> 
# 135 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ?depth (eval_uconstrs ist lems) db 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "autounfold" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("autounfold", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_clause_dft_concl), 
                                                              Tacentries.TyNil))), 
           (fun db cl ist -> 
# 139 "plugins/ltac/g_auto.mlg"
                                                           Eauto.autounfold_tac db cl 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "autounfold_one" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("autounfold_one", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                  Tacentries.TyIdent ("in", 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                  Tacentries.TyNil)))), 
           (fun db id ist -> 
# 144 "plugins/ltac/g_auto.mlg"
      Eauto.autounfold_one (match db with None -> ["core"] | Some x -> "core"::x) (Some (id, Locus.InHyp)) 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("autounfold_one", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                 Tacentries.TyNil)), 
          (fun db ist -> 
# 146 "plugins/ltac/g_auto.mlg"
      Eauto.autounfold_one (match db with None -> ["core"] | Some x -> "core"::x) None 
          )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "unify" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("unify", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                         Tacentries.TyNil))), 
           (fun x y ist -> 
# 150 "plugins/ltac/g_auto.mlg"
                                      Tactics.unify x y 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("unify", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                        Tacentries.TyIdent ("with", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                        Tacentries.TyNil))))), 
          (fun x y base ist -> 
# 151 "plugins/ltac/g_auto.mlg"
                                                            
    let table = try Some (Hints.searchtable_map base) with Not_found -> None in
    match table with
    | None ->
      let msg = str "Hint table " ++ str base ++ str " not found" in
      Tacticals.tclZEROMSG msg
    | Some t ->
      let state = Hints.Hint_db.transparent_state t in
      Tactics.unify ~state x y
  
          )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "convert" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("convert", Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                           Tacentries.TyNil))), 
           (fun x y ist -> 
# 164 "plugins/ltac/g_auto.mlg"
                                        Tactics.convert x y 
           )))]


# 167 "plugins/ltac/g_auto.mlg"
 

let pr_pre_hints_path c = Hints.pp_hints_path_gen Libnames.pr_qualid c



let (wit_hints_path, hints_path) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"hints_path" 
                                   {
                                   Vernacextend.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                (Pcoq.Symbol.self))
                                                                (Pcoq.Symbol.self))
                                                                (fun q p
                                                                loc -> 
                                                                
# 183 "plugins/ltac/g_auto.mlg"
                                       Hints.PathSeq (p, q) 
                                                                ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "_"))))
                                                               (fun _ loc ->
                                                               
# 182 "plugins/ltac/g_auto.mlg"
               Hints.PathAtom Hints.PathAny 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                                               (fun g loc ->
                                                               
# 181 "plugins/ltac/g_auto.mlg"
                             Hints.PathAtom (Hints.PathHints g) 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               (Pcoq.Symbol.self))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "|"))))
                                                               (Pcoq.Symbol.self))
                                                               (fun q _ p
                                                               loc -> 
                                                               
# 180 "plugins/ltac/g_auto.mlg"
                                           Hints.PathOr (p, q) 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "eps"))))
                                                               (fun _ loc ->
                                                               
# 179 "plugins/ltac/g_auto.mlg"
                 Hints.PathEpsilon 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "emp"))))
                                                               (fun _ loc ->
                                                               
# 178 "plugins/ltac/g_auto.mlg"
                 Hints.PathEmpty 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               (Pcoq.Symbol.self))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "*"))))
                                                               (fun _ p
                                                               loc -> 
                                                               
# 177 "plugins/ltac/g_auto.mlg"
                             Hints.PathStar p 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "("))))
                                                               (Pcoq.Symbol.self))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal ")"))))
                                                               (fun _ p _
                                                               loc -> 
                                                               
# 176 "plugins/ltac/g_auto.mlg"
                                  p 
                                                               ))]);
                                   Vernacextend.arg_printer = fun env sigma -> 
                                   
# 174 "plugins/ltac/g_auto.mlg"
             pr_pre_hints_path 
                                   ;
                                   }
let _ = (wit_hints_path, hints_path)

let (wit_opthints, opthints) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"opthints" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                        [(Pcoq.Production.make
                                                          (Pcoq.Rule.stop)
                                                          (fun loc -> 
# 190 "plugins/ltac/g_auto.mlg"
           None 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                         ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm preident)))))
                                                         (fun l _ loc -> 
# 189 "plugins/ltac/g_auto.mlg"
                                   Some l 
                                                                    ))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.Val.Opt 
                                                    (Geninterp.Val.List 
                                                    (Geninterp.val_tag (Genarg.topwit wit_preident))));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                       (Genarg.ListArg 
                                                       (wit_preident)));
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                      (Genarg.ListArg 
                                                      (wit_preident)));
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                       (Genarg.ListArg 
                                                       (wit_preident)));
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 188 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                        ), (fun env sigma -> 
                                                        
# 188 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                        ), (fun env sigma -> 
                                                        
# 188 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
                                                        ));
                               }
let _ = (wit_opthints, opthints)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"HintCut" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Hint", 
                                     Vernacextend.TyTerminal ("Cut", 
                                     Vernacextend.TyTerminal ("[", Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_hints_path), 
                                                                   Vernacextend.TyTerminal ("]", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_opthints), 
                                                                   Vernacextend.TyNil)))))), 
         (let coqpp_body p dbnames
         locality = Vernactypes.vtdefault (fun () -> 
# 194 "plugins/ltac/g_auto.mlg"
                                                                                                         
  let entry = Hints.HintsCutEntry (Hints.glob_hints_path p) in
  Hints.add_hints ~locality
    (match dbnames with None -> ["core"] | Some l -> l) entry;
 
                    ) in fun p
         dbnames ?loc ~atts () -> coqpp_body p dbnames
         (Attributes.parse 
# 194 "plugins/ltac/g_auto.mlg"
                 Attributes.hint_locality
          atts)), None))]

