'''OpenGL extension NV.copy_buffer

This module customises the behaviour of the 
OpenGL.raw.GLX.NV.copy_buffer to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a mechanism to do an accelerated copy from one
	buffer object to another. This may be useful to load buffer objects
	in a "loading thread" while minimizing cost and synchronization effort
	in the "rendering thread."

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/copy_buffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.NV.copy_buffer import *
from OpenGL.raw.GLX.NV.copy_buffer import _EXTENSION_NAME

def glInitCopyBufferNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION